/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rafts.demo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import nom.tam.fits.FitsException;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

public class FocalPlaneDemo {
    public static void main(String[] args) throws InterruptedException, IOException, FitsException {
        CCDType[] types;
        FitsHeadersSpecifications.addSpecFile((String)"primary");
        FitsHeadersSpecifications.addSpecFile((String)"extended");
        FitsHeadersSpecifications.addSpecFile((String)"test_cond");
        for (CCDType type : types = new CCDType[]{CCDType.E2V, CCDType.ITL}) {
            Raft raft00 = Raft.createRaft((String)"R00", (CCDType)type);
            raft00.setParallelPosition(0);
            raft00.setSerialPosition(0);
            Raft raft43 = Raft.createRaft((String)"R43", (CCDType)type);
            raft43.setParallelPosition(4);
            raft43.setSerialPosition(3);
            ArrayList<Raft> rafts = new ArrayList<Raft>();
            rafts.add(raft00);
            rafts.add(raft43);
            for (Raft raft : rafts) {
                GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)raft, (String)"ripples", null);
                PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)raft, (GeneratedImage)generatedImage);
                for (int rebId = 0; rebId < raft.getParallelChildrenCount(); ++rebId) {
                    Reb reb = (Reb)raft.getChild(rebId, 0);
                    for (int ccdId = 0; ccdId < 3; ++ccdId) {
                        CCD ccd = (CCD)reb.getChild(0, ccdId);
                        String raftName = String.format(type.name() + "%s_S%d%d", raft.getUniqueId(), rebId, ccdId);
                        File raftFile = new File("/tmp/" + raftName + ".fits");
                        ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD((CCDInterface)ccd);
                        FitsFileWriter ffw = new FitsFileWriter(raftFile, imageSet);
                        for (SegmentInterface segment : ccd.getSegments()) {
                            ffw.write(segment.getChannel() - 1, ((Segment)segment).getRawImageData().getImageData());
                        }
                    }
                }
            }
        }
    }
}

