
package org.lsst.ccs.utilities.ccd;

/**
 * An interface to describe Segments.
 * 
 * @author turri
 */
public interface SegmentInterface {
    
    /**
     * Get the serial position of this Segment in the CCD.
     * @return the serial position.
     * 
     */
    int getSerialPosition();
    
    /**
     * Get the parallel position of this Segment in the CCD.
     * @return the parallel position.
     * 
     */
    int getParallelPosition();
    
    
    /**
     * Get the Channel number for this Segment
     * @return the Channel number
     */
    int getChannel();
    
    /**
     * Get the Segment total serial size: prescan, overscan and active size.
     * @return The Segment total serial size.
     */
    default int getSegmentTotalSerialSize() {
        return getSegmentSerialActiveSize()+getSegmentSerialOverscanSize()+getSegmentSerialPrescanSize();
    }

    /**
     * Get the Segment serial active size.
     * @return The Segment serial active size.
     */
    int getSegmentSerialActiveSize();
    
    /**
     * Get the Segment serial prescan size.
     * @return The Segment serial prescan size.
     */
    int getSegmentSerialPrescanSize();

    /**
     * Get the Segment serial overscan size.
     * @return The Segment serial overscan size.
     */
    int getSegmentSerialOverscanSize();

    /**
     * Get the Segment total parallel size: overscan and active size.
     * @return The Segment total parallel size.
     */
    default int getSegmentTotalParallelSize() {
        return getSegmentParallelActiveSize()+getSegmentParallelOverscanSize();
    }

    /**
     * Get the Segment parallel active size.
     * @return The Segment parallel active size.
     */
    int getSegmentParallelActiveSize();
    
    /**
     * Get the Segment parallel overscan size.
     * @return The Segment parallel overscan size.
     */
    int getSegmentParallelOverscanSize();
    
    /**
     * Is this segment read down in the parallel direction.
     * 
     * @return true if the Segment is read down in the parallel direction.
     */
    boolean isReadoutDown();

    /**
     * Is this segment read left in the parallel direction.
     * 
     * @return true if the Segment is read left in the parallel direction.
     */
    boolean isReadoutLeft();
    
    /**
     * Get the parent CCDInterface this segment belongs to
     * 
     * @return The parent of this segment.
     */
    CCDInterface getParentCCD();
    
    /**
     * Get the type of CCD.
     * @return The CCDType.
     * 
     */
    CCDType getCCDType();
}
