package org.lsst.ccs.utilities.ccd;

/**
 * Defines the geometry of a Raft.
 */
public class RaftGeometry {
    
    private final CCDGeometry ccdGeom;
    private final int gapInPixels;
    private final int serialCCDNumber = 1;
    private final int parallelCCDNumber = 1;
           
    public RaftGeometry() {
        this(CCDType.ITL.getGeometry(),100);
    }

    public RaftGeometry(CCDGeometry ccdGeom, int gapInPixels) {
        this.ccdGeom = ccdGeom;
        this.gapInPixels = gapInPixels;
    }
    
    public int getTotalSerialSize() {
        return getSerialCCDNumber() * ccdGeom.getActiveSerialSize() + (getParallelCCDNumber()-1) * gapInPixels;        
    }
    
    public int getTotalParallelSize() {
        return getParallelCCDNumber() * ccdGeom.getActiveParallelSize() + (getSerialCCDNumber()-1) * gapInPixels;      
    }
    
    public CCDGeometry getCcdGeometry() {
        return ccdGeom;
    }
    
    public int getSerialCCDNumber() {
        return serialCCDNumber;
    }
    
    public int getParallelCCDNumber() {
        return parallelCCDNumber;
    }
    
    public int getCCDGapInPixels() {
        return gapInPixels;
    }
}
