package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import org.lsst.ccs.geometry.Geometry;

public class Raft extends Geometry<Reb> {

    private final CCDType type;
    
    public Raft(String name, CCDType type) {
        super(name, new Dimension(type.getRaftx(), type.getRafty()), 3, 1);
        this.type = type;
    }

    @Override
    protected void addGeometryToGrid(Reb child, int p, int s) {
        if ( ! child.getType().equals(type) ) {
            throw new IllegalArgumentException("Incompatible Reb type "+child.getType().name()+" for a Raft of type "+type.name());
        }
        if (s != 0) {
            throw new IllegalArgumentException("Rafts can only accept Reb children in the parallel direction.");
        }
        int xCoord = (2-p) * child.getWidth() + (2-p)*type.getGap_inx() + (int)type.getGap_outx();
        addGeometry(child, xCoord, (int)type.getGap_outy());
    }

    public static Raft createRaft(String label, CCDType type) {
        Raft raft = new Raft(label,type);
        //Add three Rebs, right to left.
        for (int i = 2; i >= 0; i--) {
            String rebLabel = "Reb" + i;
            Reb reb = Reb.createReb(rebLabel, i, type);
            raft.addChildGeometry(reb, i, 0);
        }
        return raft;
    }

    protected CCDType getType() {
        return type;
    }
}
