package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import org.lsst.ccs.geometry.Geometry;

public class FocalPlane extends Geometry<Raft> {

    private static final int gapBetweenRafts = 50;
    private static final int sBays = 5, pBays = 5;

    public FocalPlane() {        
        super("FocalPlane", new Dimension(pBays*CCDType.E2V.getRaftx()+(pBays-1)*gapBetweenRafts,sBays*CCDType.E2V.getRafty()+(sBays-1)*gapBetweenRafts), pBays , sBays);
    }

    @Override
    protected void addGeometryToGrid(Raft child, int p, int s) {
        int yCoord = s * (child.getHeight()+gapBetweenRafts) ;
        int xCoord = p*  (child.getWidth()+ gapBetweenRafts) ;
        addGeometry(child, xCoord, yCoord);
    }

}
