/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.ImageSet;

public class DefaultFitsHeaderMetadataProvider
implements FitsHeaderMetadataProvider {
    protected final Map<String, Map<String, Object>> primaryHeaderMetadata = new HashMap<String, Map<String, Object>>();
    protected final List<Map<String, Map<String, Object>>> extendedHeaderMetadataList;
    private final int numberOfExtendedDataHeaders;
    private final Object primaryLock = new Object();
    private final Object extendedLock = new Object();

    public DefaultFitsHeaderMetadataProvider(ImageSet imageSet) {
        this.numberOfExtendedDataHeaders = imageSet.getImages().size();
        this.extendedHeaderMetadataList = new ArrayList<Map<String, Map<String, Object>>>(this.numberOfExtendedDataHeaders);
        Map<String, Object> imageSetMetadata = imageSet.getMetaData();
        if (imageSetMetadata != null) {
            this.primaryHeaderMetadata.put("imageSet", imageSetMetadata);
        }
        for (int i = 0; i < this.numberOfExtendedDataHeaders; ++i) {
            this.extendedHeaderMetadataList.add(new HashMap());
            Map<String, Map<String, Object>> result = this.extendedHeaderMetadataList.get(i);
            Map<String, Map<String, Object>> imageMetadata = imageSet.getImages().get(i).getMetaData();
            if (imageMetadata == null) continue;
            result.putAll(imageMetadata);
        }
    }

    @Override
    public Map<String, Map<String, Object>> getAdditionalExtendedHeaderMetadata(String extendedKeyword) {
        return this.getPrimaryHeaderMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Object>> getDataExtendedHeaderMetadata(int extendedIndex) {
        if (extendedIndex < 0 || extendedIndex >= this.numberOfExtendedDataHeaders) {
            throw new IllegalArgumentException("Wrong extended header data index " + extendedIndex + " must be positive and less than " + extendedIndex);
        }
        Object object = this.extendedLock;
        synchronized (object) {
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            result.putAll(this.extendedHeaderMetadataList.get(extendedIndex));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Object>> getPrimaryHeaderMetadata() {
        Object object = this.primaryLock;
        synchronized (object) {
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            result.putAll(this.primaryHeaderMetadata);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimaryHeaderMetadata(String primaryKey, Map<String, Object> map) {
        Object object = this.primaryLock;
        synchronized (object) {
            this.primaryHeaderMetadata.put(primaryKey, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataExtendedHeaderMetadata(int extendedHeaderIndex, String extendedHeaderKey, Map<String, Object> map) {
        Object object = this.extendedLock;
        synchronized (object) {
            this.extendedHeaderMetadataList.get(extendedHeaderIndex).put(extendedHeaderKey, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToPrimaryHeaderMetadata(String primaryKey, Map<String, Object> map) {
        Object object = this.primaryLock;
        synchronized (object) {
            Map<String, Object> existingMap = this.primaryHeaderMetadata.get(primaryKey);
            if (existingMap == null) {
                existingMap = new HashMap<String, Object>();
                this.primaryHeaderMetadata.put(primaryKey, existingMap);
            }
            existingMap.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToDataExtendedHeaderMetadata(int extendedHeaderIndex, String extendedHeaderKey, Map<String, Object> map) {
        Object object = this.extendedLock;
        synchronized (object) {
            Map<String, Object> existingMap = this.extendedHeaderMetadataList.get(extendedHeaderIndex).get(extendedHeaderKey);
            if (existingMap == null) {
                existingMap = new HashMap<String, Object>();
                this.extendedHeaderMetadataList.get(extendedHeaderIndex).put(extendedHeaderKey, existingMap);
            }
            existingMap.putAll(map);
        }
    }
}

