/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import java.awt.Point;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.geometry.ImageSensitiveArea;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataProvider;
import org.lsst.ccs.utilities.image.ImagePixelData;

public class Segment
extends Geometry
implements RawImageDataProvider,
ImageSensitiveArea,
SegmentInterface {
    private final int serialPrescan;
    private final int serialOverscan;
    private final int parallelOverscan;
    private final SegmentReadOutOrder readoutPoint;
    private ImagePixelData imagePixelData;
    private final int serialActive;
    private final int parallelActive;
    private final int serialPosition;
    private final int parallelPosition;
    private final int channel;
    private final CCDType ccdType;

    Segment(CCDType ccdType, String name, int serialPosition, int parallelPosition, int channel) {
        super(name, new Dimension(ccdType.getSegmentParallelActiveSize(), ccdType.getSegmentSerialActiveSize()));
        this.serialPrescan = ccdType.getSegmentSerialPrescanSize();
        this.serialOverscan = ccdType.getSegmentSerialOverscanSize();
        this.parallelOverscan = ccdType.getSegmentParallelOverscanSize();
        this.serialActive = ccdType.getSegmentSerialActiveSize();
        this.parallelActive = ccdType.getSegmentParallelActiveSize();
        this.serialPosition = serialPosition;
        this.parallelPosition = parallelPosition;
        this.readoutPoint = parallelPosition == 1 ? SegmentReadOutOrder.LeftUp : (ccdType.name().toLowerCase().contains("e2v") ? SegmentReadOutOrder.RightDown : SegmentReadOutOrder.RightUp);
        this.channel = channel;
        this.ccdType = ccdType;
    }

    @Override
    public CCDType getCCDType() {
        return this.ccdType;
    }

    void setRedout(boolean isTopRow, String CCDtype) {
        if (this.readoutPoint != null) {
            throw new RuntimeException("The Segment Readout point can only be set once!");
        }
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public int getParallelPosition() {
        return this.parallelPosition;
    }

    @Override
    public int getSerialPosition() {
        return this.serialPosition;
    }

    public SegmentReadOutOrder getSegmentReadOutPoint() {
        return this.readoutPoint;
    }

    @Override
    public int getSegmentSerialPrescanSize() {
        return this.serialPrescan;
    }

    @Override
    public int getSegmentSerialOverscanSize() {
        return this.serialOverscan;
    }

    @Override
    public int getSegmentParallelOverscanSize() {
        return this.parallelOverscan;
    }

    @Override
    public int getSegmentSerialActiveSize() {
        return this.serialActive;
    }

    @Override
    public int getSegmentParallelActiveSize() {
        return this.parallelActive;
    }

    @Override
    public int getSegmentTotalSerialSize() {
        return this.getSegmentSerialPrescanSize() + this.getSegmentSerialActiveSize() + this.getSegmentSerialOverscanSize();
    }

    @Override
    public int getSegmentTotalParallelSize() {
        return this.getSegmentParallelActiveSize() + this.getSegmentParallelOverscanSize();
    }

    @Override
    public boolean isReadoutDown() {
        return this.readoutPoint.isReadoutDown();
    }

    @Override
    public boolean isReadoutLeft() {
        return this.readoutPoint.isReadoutLeft();
    }

    @Override
    public CCDInterface getParentCCD() {
        return (CCDInterface)((Object)this.getParent());
    }

    @Override
    public RawImageData getRawImageData() {
        DataStreamer streamer = new DataStreamer(this);
        ByteBuffer dest = this.createByteBuffer(this.getSegmentTotalSerialSize() * this.getSegmentTotalParallelSize());
        for (int row = 0; row < this.getSegmentParallelActiveSize(); ++row) {
            streamer.fillSerialPrescan(dest);
            streamer.fillDataRow(dest);
            streamer.fillSerialOverscan(dest);
        }
        streamer.fillParallelOverscan(dest);
        dest.flip();
        return new RawImageData(RawImageData.BitsPerPixel.BIT32, dest);
    }

    private ByteBuffer createByteBuffer(int size) {
        ByteBuffer dest = ByteBuffer.allocateDirect(size * 4);
        dest.order(ByteOrder.nativeOrder());
        return dest;
    }

    public static Segment createCCDSegment(CCDType ccdType, String label, int serialPosition, int parallelPosition, int channel) {
        return new Segment(ccdType, label, serialPosition, parallelPosition, channel);
    }

    @Override
    public void exposeToImage(ImagePixelData imagePixelData) {
        Point absoluteOrigin = this.getAbsolutePoint(new Point(0, 0));
        this.imagePixelData = new SegmentPixelData(absoluteOrigin, this.getWidth(), this.getHeight(), imagePixelData);
    }

    @Override
    public boolean hasPixelData() {
        return this.imagePixelData != null;
    }

    @Override
    public ImagePixelData getImagePixelData() {
        return this.imagePixelData;
    }

    private class SegmentPixelData
    implements ImagePixelData {
        private final int xGlobalCoordinate;
        private final int yGlobalCoordinate;
        private final int width;
        private final int height;
        private final ImagePixelData exposure;

        SegmentPixelData(Point origin, int width, int height, ImagePixelData exposure) {
            this.xGlobalCoordinate = origin.x;
            this.yGlobalCoordinate = origin.y;
            this.width = width;
            this.height = height;
            this.exposure = exposure;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getPixelData(int x, int y) {
            return this.exposure.getPixelData(x += this.xGlobalCoordinate, y += this.yGlobalCoordinate);
        }

        @Override
        public double getMaxValue() {
            return this.exposure.getMaxValue();
        }
    }

    public static enum SegmentReadOutOrder {
        LeftDown(true, true),
        LeftUp(true, false),
        RightDown(false, true),
        RightUp(false, false);

        private final boolean isLeft;
        private final boolean isDown;

        private SegmentReadOutOrder(boolean isLeft, boolean isDown) {
            this.isLeft = isLeft;
            this.isDown = isDown;
        }

        public boolean isReadoutDown() {
            return this.isDown;
        }

        public boolean isReadoutLeft() {
            return this.isLeft;
        }
    }

    private class DataStreamer {
        private final ByteBuffer serialPrescanBuffer;
        private final ByteBuffer serialOverscanBuffer;
        private final ByteBuffer parallelOverscanBuffer;
        private final ImagePixelData imagePixelData;
        private int currentImageColumn;
        private boolean increaseImageColumnCount;
        private boolean scanColumnFromTop;
        private final Segment s;

        DataStreamer(Segment s) {
            int i;
            this.serialPrescanBuffer = Segment.this.createByteBuffer(s.getSegmentSerialPrescanSize());
            this.serialOverscanBuffer = Segment.this.createByteBuffer(s.getSegmentSerialOverscanSize());
            this.parallelOverscanBuffer = Segment.this.createByteBuffer(s.getSegmentParallelOverscanSize() * s.getSegmentTotalSerialSize());
            for (i = 0; i < s.getSegmentSerialPrescanSize(); ++i) {
                this.serialPrescanBuffer.putInt(0);
            }
            for (i = 0; i < s.getSegmentSerialOverscanSize(); ++i) {
                this.serialOverscanBuffer.putInt(0);
            }
            for (i = 0; i < s.getSegmentParallelOverscanSize() * s.getSegmentTotalSerialSize(); ++i) {
                this.parallelOverscanBuffer.putInt(0);
            }
            this.imagePixelData = s.getImagePixelData();
            this.s = s;
            this.reset();
        }

        public final void reset() {
            SegmentReadOutOrder readout = this.s.readoutPoint;
            if (!readout.isReadoutLeft()) {
                this.currentImageColumn = this.imagePixelData.getWidth() - 1;
                this.increaseImageColumnCount = false;
            } else {
                this.currentImageColumn = 0;
                this.increaseImageColumnCount = true;
            }
            this.scanColumnFromTop = !readout.isReadoutDown();
        }

        void fillSerialPrescan(ByteBuffer data) {
            this.serialPrescanBuffer.flip();
            data.put(this.serialPrescanBuffer);
        }

        void fillSerialOverscan(ByteBuffer data) {
            this.serialOverscanBuffer.flip();
            data.put(this.serialOverscanBuffer);
        }

        void fillParallelOverscan(ByteBuffer data) {
            this.parallelOverscanBuffer.flip();
            data.put(this.parallelOverscanBuffer);
        }

        void fillDataRow(ByteBuffer data) {
            if (!this.scanColumnFromTop) {
                for (int i = this.imagePixelData.getHeight() - 1; i >= 0; --i) {
                    int value = this.imagePixelData.getPixelData(this.currentImageColumn, i);
                    data.putInt(value);
                }
            } else {
                for (int i = 0; i < this.imagePixelData.getHeight(); ++i) {
                    int value = this.imagePixelData.getPixelData(this.currentImageColumn, i);
                    data.putInt(value);
                }
            }
            this.currentImageColumn = this.increaseImageColumnCount ? this.currentImageColumn + 1 : this.currentImageColumn - 1;
        }
    }
}

