/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataProvider;

public class Reb
extends Geometry<CCD>
implements RawImageDataProvider {
    private final int gap_iny;
    private static final RawImageData.BitsPerPixel bits = RawImageData.BitsPerPixel.BIT32;
    private final CCDType type;

    public Reb(String name, CCDType type) {
        super(name, new Dimension(type.getCCDpx(), type.getRafty() - (int)(2.0 * type.getGap_outy())), 1, 3);
        this.type = type;
        this.gap_iny = type.getGap_iny();
    }

    @Override
    protected void addGeometryToGrid(CCD child, int p, int s) {
        if (!child.getType().equals((Object)this.type)) {
            throw new IllegalArgumentException("Incompatible CCDType " + child.getType().name() + " for a Reb of type " + this.type.name());
        }
        if (p != 0) {
            throw new IllegalArgumentException("Rebs only allow one row of CCDs in it");
        }
        int yCoord = (this.getSerialChildrenCount() - 1 - s) * (child.getHeight() + this.gap_iny);
        this.addGeometry(child, 0, yCoord);
    }

    public static Reb createReb(String label, int parallelPosition, CCDType type) {
        Reb reb = new Reb(label, type);
        for (int i = 0; i < 3; ++i) {
            String ccdLabel = "Sen" + parallelPosition + i;
            CCD ccd = CCD.createCCD(ccdLabel, type);
            reb.addChildGeometry(ccd, 0, i);
            ccd.setParallelPosition(parallelPosition);
        }
        return reb;
    }

    protected CCDType getType() {
        return this.type;
    }

    @Override
    public RawImageData getRawImageData() {
        int totalSize = 0;
        ArrayList<ByteBuffer> availableData = new ArrayList<ByteBuffer>();
        int segCount = 0;
        for (int s = 0; s < this.getSerialChildrenCount(); ++s) {
            CCD ccd = (CCD)this.getChild(0, s);
            for (SegmentInterface segment : ccd.getSegments()) {
                RawImageData imageData = ((Segment)segment).getRawImageData();
                availableData.add(imageData.getImageData());
                totalSize += imageData.getImageData().limit();
                ++segCount;
            }
        }
        ByteBuffer result = ByteBuffer.allocateDirect(totalSize);
        result.order(ByteOrder.nativeOrder());
        int segmentData = totalSize / segCount / bits.bytes();
        for (int i = 0; i < segmentData; ++i) {
            for (ByteBuffer byteBuffer : availableData) {
                result.putInt(byteBuffer.getInt());
            }
        }
        result.flip();
        return new RawImageData(bits, result);
    }
}

