/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.SegmentInterface;

public class CCDGeometry
implements CCDInterface {
    private final int segmentRowCount;
    private final int segmentColumnCount;
    private final int serialPrescan;
    private final int parallelActive;
    private final int serialActive;
    private final int serialOverscan;
    private final int parallelOverscan;
    private final List<CCDSegment> segments;
    private final CCDSegment[] channelMap;
    private final CCDType type;

    public CCDGeometry(int segmentRowCount, int segmentColumnCount, int serialActive, int parallelActive, int serialPrescan, int serialOverscan, int parallelOverscan, CCDType type) {
        this.segmentRowCount = segmentRowCount;
        this.segmentColumnCount = segmentColumnCount;
        this.serialPrescan = serialPrescan;
        this.parallelActive = parallelActive;
        this.serialActive = serialActive;
        this.serialOverscan = serialOverscan;
        this.parallelOverscan = parallelOverscan;
        this.segments = new ArrayList<CCDSegment>(segmentRowCount * segmentColumnCount);
        this.channelMap = new CCDSegment[segmentRowCount * segmentColumnCount];
        this.type = type;
    }

    public CCDGeometry getROIGeometry(int rows, int cols, int overRows, int overCols) {
        CCDGeometry g = new CCDGeometry(this.segmentRowCount, this.segmentColumnCount, cols, rows, 0, overCols, overRows, this.type);
        for (CCDSegment seg : this.segments) {
            g.addSegment(seg.channel, seg.row, seg.column, seg.readout);
        }
        return g;
    }

    public int getSerialPrescanCount() {
        return this.serialPrescan;
    }

    public int getParallelActiveCount() {
        return this.parallelActive;
    }

    public int getSerialActiveCount() {
        return this.serialActive;
    }

    public int getSerialOverscanCount() {
        return this.serialOverscan;
    }

    public int getParallelOverscanCount() {
        return this.parallelOverscan;
    }

    public int getTotalSerialCount() {
        return this.getSerialPrescanCount() + this.getSerialActiveCount() + this.getSerialOverscanCount();
    }

    public int getTotalParallelCount() {
        return this.getParallelActiveCount() + this.getParallelOverscanCount();
    }

    @Override
    public int getTotalSerialSize() {
        return this.getTotalSerialCount() * this.getSerialSegmentCount();
    }

    @Override
    public int getActiveSerialSize() {
        return this.getSerialActiveCount() * this.getSerialSegmentCount();
    }

    @Override
    public int getTotalParallelSize() {
        return this.getTotalParallelCount() * this.getParallelSegmentCount();
    }

    @Override
    public int getActiveParallelSize() {
        return this.getParallelActiveCount() * this.getParallelSegmentCount();
    }

    @Override
    public CCDType getType() {
        return this.type;
    }

    @Override
    public SegmentInterface getSegment(int column, int row) {
        assert (row >= 0 && row < this.segmentRowCount);
        assert (column >= 0 && column < this.segmentColumnCount);
        return this.channelMap[column * this.segmentRowCount + row];
    }

    @Override
    public List<SegmentInterface> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public void addSegment(int channel, int row, int column, ReadoutOrder readoutOrder) {
        CCDSegment segment = new CCDSegment(channel, row, column, readoutOrder, this.getType());
        this.segments.add(segment);
        this.channelMap[column * this.segmentRowCount + row] = segment;
    }

    @Override
    public int getParallelSegmentCount() {
        return this.segmentColumnCount;
    }

    @Override
    public int getSerialSegmentCount() {
        return this.segmentRowCount;
    }

    @Override
    public int getActiveAreaParallelSize() {
        return this.type.getActiveAreaParallelSize();
    }

    @Override
    public int getActiveAreaSerialSize() {
        return this.type.getActiveAreaSerialSize();
    }

    @Override
    public int getPhysicalAreaParallelSize() {
        return this.type.getPhysicalAreaParallelSize();
    }

    @Override
    public int getPhysicalAreaSerialSize() {
        return this.type.getPhysicalAreaSerialSize();
    }

    public class CCDSegment
    implements SegmentInterface {
        private ReadoutOrder readout;
        private int channel;
        private int row;
        private int column;
        private final CCDType type;

        private CCDSegment(int channel, int row, int column, ReadoutOrder readout, CCDType type) {
            this.readout = readout;
            this.channel = channel;
            this.row = row;
            this.column = column;
            this.type = type;
        }

        @Override
        public CCDType getCCDType() {
            return this.type;
        }

        @Override
        public int getParallelPosition() {
            return this.column;
        }

        @Override
        public int getSerialPosition() {
            return this.row;
        }

        @Override
        public int getChannel() {
            return this.channel;
        }

        @Override
        public int getSegmentTotalSerialSize() {
            return CCDGeometry.this.getTotalSerialCount();
        }

        @Override
        public int getSegmentSerialActiveSize() {
            return CCDGeometry.this.getSerialActiveCount();
        }

        @Override
        public int getSegmentSerialPrescanSize() {
            return CCDGeometry.this.getSerialPrescanCount();
        }

        @Override
        public int getSegmentSerialOverscanSize() {
            return CCDGeometry.this.getSerialOverscanCount();
        }

        @Override
        public int getSegmentTotalParallelSize() {
            return CCDGeometry.this.getTotalParallelCount();
        }

        @Override
        public int getSegmentParallelActiveSize() {
            return CCDGeometry.this.getParallelActiveCount();
        }

        @Override
        public int getSegmentParallelOverscanSize() {
            return CCDGeometry.this.getParallelOverscanCount();
        }

        @Override
        public boolean isReadoutDown() {
            return this.readout.isDown();
        }

        @Override
        public boolean isReadoutLeft() {
            return !this.readout.isRight();
        }

        public ReadoutOrder getReadout() {
            return this.readout;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        @Override
        public CCDGeometry getParentCCD() {
            return CCDGeometry.this;
        }

        public String toString() {
            return "CCDSegment{readout=" + (Object)((Object)this.readout) + ", channel=" + this.channel + ", row=" + this.row + ", column=" + this.column + '}';
        }
    }

    public static enum ReadoutOrder {
        DownRight(true, true),
        UpRight(false, true),
        DownLeft(true, false),
        UpLeft(false, false);

        private boolean down;
        private boolean right;

        private ReadoutOrder(boolean down, boolean right) {
            this.down = down;
            this.right = right;
        }

        public boolean isDown() {
            return this.down;
        }

        public boolean isRight() {
            return this.right;
        }
    }
}

