/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.patterns;

import java.util.Map;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGenerator;

public class CheckeredPatternGenerator
extends PatternGenerator {
    CheckeredPatternGenerator() {
        super("checkered");
    }

    @Override
    public GeneratedImage generateImage(int width, int height, Map<String, String> parameters) {
        int checkered_baseline = this.getIntParameter("checkered_baseline", parameters, 128);
        int checkered_maxAmplitude = this.getIntParameter("checkered_maxAmplitude", parameters, 256);
        double checkered_frequency = this.getDoubleParameter("checkered_frequency", parameters, 32.0);
        int maxFluctuation = Math.max(checkered_maxAmplitude - checkered_baseline, 0);
        int[][] data = new int[width][height];
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                int value;
                data[w][h] = value = checkered_baseline + (int)((double)maxFluctuation * Math.sin((double)w / checkered_frequency) * Math.sin((double)h / checkered_frequency));
            }
        }
        return new GeneratedImage(data, checkered_maxAmplitude);
    }
}

