/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Reb;

public class Raft
extends Geometry<Reb> {
    private final int rebGap = 10;

    public Raft(String name) {
        super(name, 1, 3);
    }

    @Override
    protected void addGeometryToGrid(Reb child, int s, int p) {
        if (s != 0) {
            throw new IllegalArgumentException("Rafts can only accept Reb children in the parallel direction.");
        }
        int yCoord = (2 - p) * child.getHeight();
        this.addGeometry(child, 0, yCoord += (2 - p) * 10);
    }

    public static Raft createRaft(String label, CCDType type) {
        Raft raft = new Raft(label);
        for (int i = 2; i >= 0; --i) {
            String rebLabel = "Reb" + i;
            Reb reb = Reb.createReb(rebLabel, i, type);
            raft.addChildGeometry(reb, 0, i);
        }
        return raft;
    }
}

