package org.lsst.ccs.utilities.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * A default implementation of ImageSet.
 *
 * @author tonyj
 */
public class DefaultImageSet implements ImageSet {

    private final List<Image> images = new ArrayList<>();
    private final HashMap<String, Object> metaData = new HashMap<>();
    private final String id;

    /**
     * Create an ImageSet with no global meta-data
     */
    public DefaultImageSet() {
        this("notSet");
    }
    
    public DefaultImageSet(String id) {
        this.id = id;
    }
    /**
     * Create an ImageSet
     * @param metaData The global meta-data to associated with the ImageSet itself
     */
    public DefaultImageSet(Map<String, Object> metaData) {
        this();
        this.metaData.putAll(metaData);        
    }

    @Override
    public List<Image> getImages() {
        return Collections.unmodifiableList(images);
    }

    @Override
    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(metaData);
    }

    @Override
    public String getImageSetId() {
        return id;
    }
    
    public void addImage(int width, int height,
            Map<String, Map<String, Object>> metaData) {
        images.add(new DefaultImage(width, height, metaData));
    }

    private static class DefaultImage implements Image {

        private final int width;
        private final int height;
        private final HashMap<String, Map<String, Object>> metaData = new HashMap<>();

        public DefaultImage(int width, int height, Map<String, Map<String, Object>> metaData) {
            this.width = width;
            this.height = height;
            if ( metaData != null ) {
                this.metaData.putAll(metaData);
            }
        }

        @Override
        public Map<String, Map<String, Object>> getMetaData() {
            return Collections.unmodifiableMap(metaData);
        }

        @Override
        public int getWidth() {
            return width;
        }

        @Override
        public int getHeight() {
            return height;
        }

    }

}
