
package org.lsst.ccs.geometry;

import java.awt.Point;
import java.util.Map;

/**
 *
 * @author turri
 */
public class GeometryUtils {

    
    public static String showGeometryTree(Geometry geometry) {
        return showGeometryTree(geometry, -1);
    }
    public static String showGeometryTree(Geometry geometry, int depth) {
        StringBuilder sb = new StringBuilder();
        printGeometryTree(geometry,depth, 0, sb);
        return sb.toString();
    }

    private static void printGeometryTree(Geometry geom, int depth, int level, StringBuilder sb) {
        if ( depth > 0 && level >= depth ) {
            return;
        }
        level++;
        String indent = "";
        for ( int i = 0; i < level; i++ ) {
            indent += "-";
        }
        sb.append(indent).append("-> ").append(geom.getUniqueId()).append("\n");
        if (geom.hasChildren()) {
            Map<Geometry, Point> children = geom.getChildrenWithAbsoluteCoordinates();
            for ( int p = geom.getParallelChildrenCount() - 1; p>=0; p-- ) {
                for ( int s = 0; s<geom.getSerialChildrenCount(); s++ ) {
                    Geometry child = geom.getChild(s, p);
                    if ( child != null ) {
                        printGeometryTree(child, depth, level, sb);
                    }                    
                }
            }
        }
    }

}
