/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsHeaderUtilities {
    private static String pair(String a, String b) {
        return "[" + a + "," + b + "]";
    }

    private static String range(int a, int b) {
        return a + ":" + b;
    }

    private static String range(int a, int b, boolean flip) {
        return flip ? FitsHeaderUtilities.range(b, a) : FitsHeaderUtilities.range(a, b);
    }

    public static ImageSet createImageSetForCCD(CCDInterface ccd) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.putAll(FitsHeaderUtilities.getCCDPrimaryHeaders(ccd));
        DefaultImageSet imageSet = new DefaultImageSet(metaData);
        for (SegmentInterface segment : ccd.getSegments()) {
            MetaDataSet metaDataSet = new MetaDataSet();
            Map<String, Object> imageMetaData = FitsHeaderUtilities.getSegmentHeaders(segment, false);
            metaDataSet.addMetaData("channel", imageMetaData);
            FitsHeaderUtilities.addRaftLevelMetadata(segment, metaDataSet, imageMetaData);
            imageSet.addImage(ccd.getType().getSegmentTotalSerialSize(), ccd.getType().getSegmentTotalParallelSize(), metaDataSet);
        }
        return imageSet;
    }

    private static void addRaftLevelMetadata(SegmentInterface segment, MetaDataSet imageMetaData, Map<String, Object> segmentHeaders) {
        Raft parentRaft = FitsHeaderUtilities.findRaftForGeometry((Geometry)((Object)segment));
        if (parentRaft != null) {
            Point raftPosition = parentRaft.getGeometryAbsolutePosition();
            Point segmentPosition = ((Geometry)((Object)segment)).getGeometryAbsolutePosition();
            int segmentXPositionInRaft = segmentPosition.x - raftPosition.x;
            int segmentYPositionInRaft = segmentPosition.y - raftPosition.y;
            HashMap<String, Object> extra = new HashMap<String, Object>();
            extra.put("WCSNAMEr", "RAFT");
            extra.put("CTYPE1r", "RAFT_X");
            extra.put("CTYPE2r", "RAFT_Y");
            extra.put("CUNIT1r", "pixel");
            extra.put("CUNIT2r", "pixel");
            extra.put("PC1_1r", segmentHeaders.get("PC1_1"));
            extra.put("PC1_2r", 0.0);
            extra.put("PC2_1r", 0.0);
            extra.put("PC2_2r", segmentHeaders.get("PC2_2"));
            extra.put("CDELT1r", 1.0);
            extra.put("CDELT2r", 1.0);
            extra.put("CRPIX1r", segmentXPositionInRaft);
            extra.put("CRPIX2r", segmentYPositionInRaft);
            imageMetaData.addMetaData("raft-wcs", extra);
        }
    }

    private static Raft findRaftForGeometry(Geometry<?> geom) {
        Geometry parent = geom.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof Raft) {
            return (Raft)parent;
        }
        return FitsHeaderUtilities.findRaftForGeometry(parent);
    }

    public static Map<String, Object> getCCDPrimaryHeaders(CCDInterface ccd) {
        HashMap<String, Object> primaryMetaData = new HashMap<String, Object>();
        primaryMetaData.put("DETSIZE", FitsHeaderUtilities.getCCDDetSize(ccd));
        return primaryMetaData;
    }

    private static String getCCDDetSize(CCDInterface ccd) {
        return FitsHeaderUtilities.pair(FitsHeaderUtilities.range(1, ccd.getActiveSerialSize()), FitsHeaderUtilities.range(1, ccd.getActiveParallelSize()));
    }

    public static Map<String, Object> getSegmentHeaders(SegmentInterface seg) {
        return FitsHeaderUtilities.getSegmentHeaders(seg, false);
    }

    public static Map<String, Object> getSegmentHeaders(SegmentInterface segment, boolean treatOverAndUnderscanAsActive) {
        HashMap<String, Object> imageMetaData = new HashMap<String, Object>();
        imageMetaData.put("EXTNAME", String.format("Segment%01d%01d", FitsHeaderUtilities.getSegmentParallelPosition(segment), FitsHeaderUtilities.getSegmentSerialPosition(segment)));
        imageMetaData.put("CHANNEL", segment.getChannel());
        imageMetaData.put("DATASEC", FitsHeaderUtilities.getDataSec(segment, treatOverAndUnderscanAsActive));
        imageMetaData.put("DETSEC", FitsHeaderUtilities.getDetSec(segment, treatOverAndUnderscanAsActive));
        if (!treatOverAndUnderscanAsActive) {
            imageMetaData.put("BIASSEC", FitsHeaderUtilities.getBiasSec(segment));
        }
        imageMetaData.put("CCDSUM", "1 1");
        imageMetaData.put("LTV1", FitsHeaderUtilities.getLTV1(segment));
        imageMetaData.put("LTV2", FitsHeaderUtilities.getLTV2(segment));
        imageMetaData.put("LTM1_1", FitsHeaderUtilities.getLTM11(segment));
        imageMetaData.put("LTM2_2", FitsHeaderUtilities.getLTM22(segment));
        imageMetaData.put("WCSNAME", "PRIMARY");
        imageMetaData.put("CTYPE1", "CCD_X");
        imageMetaData.put("CTYPE2", "CCD_Y");
        imageMetaData.put("CUNIT1", "pixel");
        imageMetaData.put("CUNIT2", "pixel");
        imageMetaData.put("PC1_1", FitsHeaderUtilities.getPC11(segment));
        imageMetaData.put("PC1_2", 0.0);
        imageMetaData.put("PC2_1", 0.0);
        imageMetaData.put("PC2_2", FitsHeaderUtilities.getPC22(segment));
        imageMetaData.put("CDELT1", 1.0);
        imageMetaData.put("CDELT2", 1.0);
        imageMetaData.put("CRPIX1", FitsHeaderUtilities.getCRPIX1(segment));
        imageMetaData.put("CRPIX2", FitsHeaderUtilities.getCRPIX2(segment));
        return imageMetaData;
    }

    private static int getSegmentParallelPosition(SegmentInterface seg) {
        return seg.getParallelPosition();
    }

    private static int getSegmentSerialPosition(SegmentInterface seg) {
        return seg.getSerialPosition();
    }

    private static boolean isReadoutDown(SegmentInterface seg) {
        return seg.isReadoutDown();
    }

    private static boolean isReadoutLeft(SegmentInterface seg) {
        return seg.isReadoutLeft();
    }

    private static String getDetSec(SegmentInterface segment, boolean treatOverAndUnderscanAsActive) {
        if (treatOverAndUnderscanAsActive) {
            return FitsHeaderUtilities.pair(FitsHeaderUtilities.range(segment.getSegmentTotalSerialSize() * FitsHeaderUtilities.getSegmentSerialPosition(segment) + 1, segment.getSegmentTotalSerialSize() * (FitsHeaderUtilities.getSegmentSerialPosition(segment) + 1), !FitsHeaderUtilities.isReadoutLeft(segment)), FitsHeaderUtilities.range(segment.getSegmentTotalParallelSize() * FitsHeaderUtilities.getSegmentParallelPosition(segment) + 1, segment.getSegmentTotalParallelSize() * (FitsHeaderUtilities.getSegmentParallelPosition(segment) + 1), !FitsHeaderUtilities.isReadoutDown(segment)));
        }
        return FitsHeaderUtilities.pair(FitsHeaderUtilities.range(segment.getSegmentSerialActiveSize() * FitsHeaderUtilities.getSegmentSerialPosition(segment) + 1, segment.getSegmentSerialActiveSize() * (FitsHeaderUtilities.getSegmentSerialPosition(segment) + 1), !FitsHeaderUtilities.isReadoutLeft(segment)), FitsHeaderUtilities.range(segment.getSegmentParallelActiveSize() * FitsHeaderUtilities.getSegmentParallelPosition(segment) + 1, segment.getSegmentParallelActiveSize() * (FitsHeaderUtilities.getSegmentParallelPosition(segment) + 1), !segment.isReadoutDown()));
    }

    private static String getDataSec(SegmentInterface segment, boolean treatOverAndUnderscanAsActive) {
        if (treatOverAndUnderscanAsActive) {
            return FitsHeaderUtilities.pair(FitsHeaderUtilities.range(1, segment.getSegmentTotalSerialSize()), FitsHeaderUtilities.range(1, segment.getSegmentTotalParallelSize()));
        }
        return FitsHeaderUtilities.pair(FitsHeaderUtilities.range(segment.getSegmentSerialPrescanSize() + 1, segment.getSegmentSerialActiveSize() + segment.getSegmentSerialPrescanSize()), FitsHeaderUtilities.range(1, segment.getSegmentParallelActiveSize()));
    }

    private static String getBiasSec(SegmentInterface segment) {
        return FitsHeaderUtilities.pair(FitsHeaderUtilities.range(segment.getSegmentSerialActiveSize() + segment.getSegmentSerialPrescanSize() + 1, segment.getSegmentSerialActiveSize() + segment.getSegmentSerialPrescanSize() + segment.getSegmentSerialOverscanSize()), FitsHeaderUtilities.range(1, segment.getSegmentParallelActiveSize()));
    }

    private static double getLTV1(SegmentInterface seg) {
        return FitsHeaderUtilities.isReadoutDown(seg) ? (double)(seg.getSegmentSerialActiveSize() * (seg.getParallelPosition() + 1)) : (double)(-(seg.getSegmentSerialActiveSize() * seg.getParallelPosition()));
    }

    private static double getLTV2(SegmentInterface seg) {
        return !FitsHeaderUtilities.isReadoutLeft(seg) ? (double)(seg.getSegmentParallelActiveSize() * (seg.getSerialPosition() + 1)) : (double)(seg.getSegmentParallelActiveSize() * seg.getSerialPosition());
    }

    private static double getLTM11(SegmentInterface seg) {
        return FitsHeaderUtilities.isReadoutDown(seg) ? -1.0 : 1.0;
    }

    private static double getLTM22(SegmentInterface seg) {
        return !FitsHeaderUtilities.isReadoutLeft(seg) ? -1.0 : 1.0;
    }

    private static double getPC11(SegmentInterface seg) {
        return !FitsHeaderUtilities.isReadoutLeft(seg) ? -1.0 : 1.0;
    }

    private static double getPC22(SegmentInterface seg) {
        return !FitsHeaderUtilities.isReadoutDown(seg) ? -1.0 : 1.0;
    }

    private static double getCRPIX1(SegmentInterface seg) {
        return !FitsHeaderUtilities.isReadoutLeft(seg) ? (double)(seg.getSegmentTotalSerialSize() * (FitsHeaderUtilities.getSegmentSerialPosition(seg) + 1) + 1) : (double)(-(seg.getSegmentTotalSerialSize() * FitsHeaderUtilities.getSegmentSerialPosition(seg)));
    }

    private static double getCRPIX2(SegmentInterface seg) {
        return !FitsHeaderUtilities.isReadoutDown(seg) ? (double)(seg.getSegmentTotalParallelSize() * (FitsHeaderUtilities.getSegmentParallelPosition(seg) + 1) + 1) : (double)(seg.getSegmentTotalParallelSize() * FitsHeaderUtilities.getSegmentParallelPosition(seg));
    }
}

