/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDType;

public class RaftGeometry {
    private final CCDGeometry ccdGeom;
    private final int gapInPixels;
    private final int serialCCDNumber = 1;
    private final int parallelCCDNumber = 1;

    public RaftGeometry() {
        this(CCDType.ITL.getGeometry(), 100);
    }

    public RaftGeometry(CCDGeometry ccdGeom, int gapInPixels) {
        this.ccdGeom = ccdGeom;
        this.gapInPixels = gapInPixels;
    }

    public int getTotalSerialSize() {
        return this.getSerialCCDNumber() * this.ccdGeom.getActiveSerialSize() + (this.getParallelCCDNumber() - 1) * this.gapInPixels;
    }

    public int getTotalParallelSize() {
        return this.getParallelCCDNumber() * this.ccdGeom.getActiveParallelSize() + (this.getSerialCCDNumber() - 1) * this.gapInPixels;
    }

    public CCDGeometry getCcdGeometry() {
        return this.ccdGeom;
    }

    public int getSerialCCDNumber() {
        return 1;
    }

    public int getParallelCCDNumber() {
        return 1;
    }

    public int getCCDGapInPixels() {
        return this.gapInPixels;
    }
}

