/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.geometry;

import java.awt.Point;
import java.util.Map;
import org.lsst.ccs.geometry.Geometry;

public class GeometryUtils {
    public static String showGeometryTree(Geometry geometry) {
        return GeometryUtils.showGeometryTree(geometry, -1);
    }

    public static String showGeometryTree(Geometry geometry, int depth) {
        StringBuilder sb = new StringBuilder();
        GeometryUtils.printGeometryTree(geometry, depth, 0, sb);
        return sb.toString();
    }

    private static void printGeometryTree(Geometry geom, int depth, int level, StringBuilder sb) {
        if (depth > 0 && level >= depth) {
            return;
        }
        ++level;
        String indent = "";
        for (int i = 0; i < level; ++i) {
            indent = indent + "-";
        }
        sb.append(indent).append("-> ").append(geom.getUniqueId()).append("\n");
        if (geom.hasChildren()) {
            Map<Geometry, Point> children = geom.getChildrenWithAbsoluteCoordinates();
            for (int p = geom.getParallelChildrenCount() - 1; p >= 0; --p) {
                for (int s = 0; s < geom.getSerialChildrenCount(); ++s) {
                    Object child = geom.getChild(s, p);
                    if (child == null) continue;
                    GeometryUtils.printGeometryTree(child, depth, level, sb);
                }
            }
        }
    }
}

