/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.geometry;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Map;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;

public class GeometryRenderer {
    public static void renderGeometry(Geometry<?> geometry, Graphics g, Point p) {
        GeometryRenderer.renderGeometrySpecificDetails(geometry, g, p);
        if (geometry.hasChildren()) {
            Map<Geometry, Point> children = geometry.getChildrenWithAbsoluteCoordinates();
            for (Geometry child : children.keySet()) {
                GeometryRenderer.renderGeometry(child, g, children.get(child));
            }
        }
    }

    private static void renderGeometrySpecificDetails(Geometry<?> geom, Graphics g, Point p) {
        if (geom instanceof CCD) {
            GeometryRenderer.renderCCDGeometry((CCD)geom, g, p);
        } else if (geom instanceof Raft) {
            GeometryRenderer.renderRaftGeometry((Raft)geom, g, p);
        } else if (geom instanceof Reb) {
            GeometryRenderer.renderRebGeometry((Reb)geom, g, p);
        } else if (geom instanceof Segment) {
            GeometryRenderer.renderSegmentGeometry((Segment)geom, g, p);
        }
    }

    private static void renderCCDGeometry(CCD geom, Graphics g, Point p) {
        g.drawRect(p.x, p.y, geom.getWidth(), geom.getHeight());
        Color orig = g.getColor();
        Color blue = Color.BLUE;
        g.setColor(blue);
        if (!geom.getName().isEmpty()) {
            int textHeight = g.getFontMetrics().getHeight();
            int textWidth = g.getFontMetrics().stringWidth(geom.getName());
            int xLabel = p.x + (geom.getWidth() - textWidth) / 2;
            int yLabel = p.y + geom.getHeight() / 2 + textHeight + 2;
            g.drawString(geom.getName(), xLabel, yLabel);
        }
        g.setColor(orig);
    }

    private static void renderRaftGeometry(Raft geom, Graphics g, Point p) {
        Color orig = g.getColor();
        Color green = Color.ORANGE;
        g.setColor(green);
        g.drawRect(p.x, p.y, geom.getWidth(), geom.getHeight());
        if (!geom.getName().isEmpty()) {
            int xLabel = p.x + (int)((double)geom.getWidth() * 0.05);
            int yLabel = p.y + (int)((double)geom.getHeight() * 0.05);
            g.drawString(geom.getName(), xLabel, yLabel);
        }
        g.setColor(orig);
    }

    private static void renderRebGeometry(Reb geom, Graphics g, Point p) {
        int rebLineY = p.y + (int)((double)geom.getHeight() * 0.2);
        int lineWidth = (int)((double)geom.getWidth() * 0.85);
        int rebLineX = p.x + (geom.getWidth() - lineWidth) / 2;
        Color orig = g.getColor();
        Color green = Color.GREEN;
        g.setColor(green);
        g.fillRect(rebLineX, rebLineY, lineWidth, 4);
        if (!geom.getName().isEmpty()) {
            int textHeight = g.getFontMetrics().getHeight();
            int xLabel = rebLineX + 3;
            int yLabel = rebLineY + 3 + textHeight;
            g.drawString(geom.getName(), xLabel, yLabel);
        }
        g.setColor(orig);
    }

    private static void renderSegmentGeometry(Segment geom, Graphics g, Point p) {
        int width = geom.getWidth();
        int height = geom.getHeight();
        int xLabel = (int)((double)width * 0.5);
        int yLabel = (int)((double)width * 0.25);
        int textHeight = g.getFontMetrics().getHeight();
        int textWidth = g.getFontMetrics().stringWidth(geom.getName());
        g.drawRect(p.x, p.y, geom.getWidth(), geom.getHeight());
        Color old = g.getColor();
        Color red = Color.RED;
        g.setColor(red);
        int squareSize = 4;
        if (geom.getSegmentReadOutPoint().isParallelDown()) {
            yLabel = p.y + height - yLabel;
            if (!geom.getSegmentReadOutPoint().isSerialLeft()) {
                g.fillRect(p.x + geom.getWidth() - squareSize, p.y + height - squareSize, squareSize, squareSize);
            } else {
                g.fillRect(p.x, p.y + height - squareSize, squareSize, squareSize);
            }
        } else {
            yLabel = p.y + yLabel + textHeight;
            if (!geom.getSegmentReadOutPoint().isSerialLeft()) {
                g.fillRect(p.x + geom.getWidth() - squareSize, p.y, squareSize, squareSize);
            } else {
                g.fillRect(p.x, p.y, squareSize, squareSize);
            }
        }
        g.setColor(old);
        xLabel = p.x + xLabel - textWidth / 2;
        g.drawString(geom.getName(), xLabel, yLabel);
    }
}

