/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.geometry;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Geometry<T extends Geometry> {
    private Dimension dimension;
    private final List<InnerGeometry<T>> components = new ArrayList<InnerGeometry<T>>();
    private Geometry parent;
    private boolean hasFixedDimension = false;
    private final String name;
    private Geometry[][] children;
    protected final int serialChildrenCount;
    protected final int parallelChildrenCount;
    protected int serialPosition;
    protected int parallelPosition;

    public Geometry(String name, int s, int p) {
        this.dimension = new Dimension(0, 0);
        this.name = name;
        this.children = new Geometry[s][p];
        this.serialChildrenCount = s;
        this.parallelChildrenCount = p;
    }

    public Geometry(String name) {
        this.dimension = new Dimension(0, 0);
        this.name = name;
        this.serialChildrenCount = 0;
        this.parallelChildrenCount = 0;
    }

    protected void setDimension(int width, int height) {
        this.dimension = new Dimension(width, height);
        this.hasFixedDimension = true;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.dimension.width;
    }

    public int getHeight() {
        return this.dimension.height;
    }

    public Dimension getDimension() {
        return new Dimension(this.dimension);
    }

    public Geometry getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    protected final void setParent(Geometry parent) {
        if (this.parent != null) {
            throw new RuntimeException("This Geometry already already has a parent!");
        }
        this.parent = parent;
    }

    protected void addGeometry(T child, int x, int y) {
        if (this.getParent() != null && !this.hasFixedDimension) {
            throw new RuntimeException("Cannot add a child Geometry to a non orfan parent Geometry with variable dimensions");
        }
        if (((Geometry)child).getParent() != null) {
            throw new RuntimeException("The child geometry already belongs to another Geometry.");
        }
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("Illegal placement position (" + x + "," + y + "), coordiantes cannot be negative");
        }
        if (this.hasFixedDimension) {
            if (x > this.getWidth() || y > this.getHeight()) {
                throw new IllegalArgumentException("Illegal placement position (" + x + "," + y + "), it is outside of this geometry's size " + this.getWidth() + "x" + this.getHeight());
            }
            if (x + ((Geometry)child).getWidth() > this.getWidth() || y + ((Geometry)child).getHeight() > this.getHeight()) {
                throw new IllegalArgumentException("The child Geometry cannot be added within the boundaries of this Geometry " + this.getWidth() + "x" + this.getHeight());
            }
        }
        ((Geometry)child).setParent(this);
        Point point = new Point(x, y);
        this.components.add(new InnerGeometry(this, child, point));
        if (!this.hasFixedDimension) {
            this.dimension.setSize(Math.max(this.getWidth(), x + ((Geometry)child).getWidth()), Math.max(this.getHeight(), y + ((Geometry)child).getHeight()));
        }
    }

    public int getSerialChildrenCount() {
        return this.serialChildrenCount;
    }

    public int getParallelChildrenCount() {
        return this.parallelChildrenCount;
    }

    public int getSerialPosition() {
        return this.serialPosition;
    }

    public int getParallelPosition() {
        return this.parallelPosition;
    }

    public void addChildGeometry(T child, int s, int p) {
        this.children[s][p] = child;
        ((Geometry)child).parallelPosition = p;
        ((Geometry)child).serialPosition = s;
        this.addGeometryToGrid(child, s, p);
    }

    protected void addGeometryToGrid(T child, int s, int p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public T getChild(int s, int p) {
        return (T)this.children[s][p];
    }

    public boolean hasChildren() {
        return !this.components.isEmpty();
    }

    public final Map<Geometry, Point> getChildrenWithAbsoluteCoordinates() {
        HashMap<Geometry, Point> map = new HashMap<Geometry, Point>();
        for (InnerGeometry<T> ig : this.components) {
            map.put((Geometry)ig.getGeometry(), this.getAbsolutePoint(ig.getPoint()));
        }
        return map;
    }

    public final List<T> getChildrenList() {
        ArrayList<T> c = new ArrayList<T>();
        for (InnerGeometry<T> ig : this.components) {
            c.add(ig.getGeometry());
        }
        return c;
    }

    public final String getUniqueId() {
        return Geometry.buildUniqueId(this, "");
    }

    private static String buildUniqueId(Geometry g, String name) {
        String string = name = name.isEmpty() ? g.getName() : g.getName() + "." + name;
        if (g.hasParent()) {
            return Geometry.buildUniqueId(g.getParent(), name);
        }
        return name;
    }

    public final Geometry findGeometry(String geometryUniqueId) {
        return Geometry.findGeometry(this, geometryUniqueId);
    }

    private static Geometry findGeometry(Geometry<?> g, String geometryUniqueId) {
        if (g.getUniqueId().equals(geometryUniqueId)) {
            return g;
        }
        for (Geometry child : g.getChildrenList()) {
            Geometry found = Geometry.findGeometry(child, geometryUniqueId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public final int getNumberOfChildren() {
        return this.components.size();
    }

    public Point getGeometryAbsolutePosition() {
        return this.getAbsolutePoint(new Point(0, 0));
    }

    public Point getAbsolutePoint(Point p) {
        if (!this.hasParent()) {
            return p;
        }
        Point thisGeometryPoint = this.getParent().getGeometryPoint(this);
        Point p1 = new Point(p.x + thisGeometryPoint.x, p.y + thisGeometryPoint.y);
        return this.getParent().getAbsolutePoint(p1);
    }

    public Point getGeometryPoint(Geometry geometry) {
        for (InnerGeometry<T> ig : this.components) {
            if (ig.getGeometry() != geometry) continue;
            return ig.getPoint();
        }
        throw new RuntimeException("Could not find location for this Geometry: " + geometry);
    }

    protected void setExpandedView(boolean expandedView) {
    }

    private void reset() {
        this.parent = null;
        this.components.clear();
        if (!this.hasFixedDimension) {
            this.dimension = new Dimension(0, 0);
        }
    }

    public static void convertToExpandedView(Geometry<?> geometry, boolean expandedView) {
        if (geometry.getParent() != null) {
            throw new IllegalArgumentException("Cannot convert a Geometry that belongs to a parent. The conversion must happen at the top level");
        }
        Geometry.internalConvert(geometry, expandedView);
    }

    private static void internalConvert(Geometry geometry, boolean expandedView) {
        geometry.reset();
        for (int s = 0; s < geometry.getSerialChildrenCount(); ++s) {
            for (int p = 0; p < geometry.getParallelChildrenCount(); ++p) {
                Object child = geometry.getChild(s, p);
                ((Geometry)child).setExpandedView(expandedView);
                Geometry.internalConvert(child, expandedView);
                geometry.addChildGeometry(child, s, p);
            }
        }
    }

    private static class InnerGeometry<K extends Geometry> {
        private final K geometry;
        private final Point point;
        final /* synthetic */ Geometry this$0;

        InnerGeometry(K geometry, Point p) {
            this.this$0 = var1_1;
            this.geometry = geometry;
            this.point = p;
        }

        K getGeometry() {
            return this.geometry;
        }

        int getXPosition() {
            return this.point.x;
        }

        int getYPosition() {
            return this.point.y;
        }

        Point getPoint() {
            return this.point;
        }
    }
}

