/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.image.HeaderSpecification;

public class FitsHeadersSpecifications {
    private static final Map<String, HeaderSpecification> imageWriterConfig = new HashMap<String, HeaderSpecification>();

    public static final void addSpecFile(String fileName) {
        FitsHeadersSpecifications.readHeaderSpecification(fileName, null);
    }

    public static final void addSpecFile(String fileName, String headerName) {
        FitsHeadersSpecifications.readHeaderSpecification(fileName, headerName);
    }

    public static final Map<String, HeaderSpecification> getHeaderSpecifications() {
        return Collections.unmodifiableMap(imageWriterConfig);
    }

    public final void removeHeaderSpecification(String headerName) {
        imageWriterConfig.remove(headerName);
    }

    public static final void removeAllHeaderSpecifications() {
        imageWriterConfig.clear();
    }

    private static void readHeaderSpecification(String name, String headerName) throws RuntimeException {
        String fileName;
        String string = fileName = name.endsWith(".spec") ? name : name + ".spec";
        if (headerName == null) {
            headerName = fileName.replace(".spec", "");
        }
        if (imageWriterConfig.containsKey(headerName)) {
            throw new IllegalArgumentException("Header name " + headerName + " already exists and cannot be overwritten.");
        }
        try (InputStream bootstrapResource = BootstrapResourceUtils.getBootstrapResource((String)fileName);){
            if (bootstrapResource == null) {
                System.out.println("Failed to open spect file " + fileName);
                return;
            }
            HeaderSpecification desc = new HeaderSpecification(headerName, bootstrapResource);
            imageWriterConfig.put(headerName, desc);
        }
        catch (IOException x) {
            throw new RuntimeException("Error reading " + fileName, x);
        }
    }
}

