/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd.image.data;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataListener;

public interface RawImageDataProvider {
    public static final List<InnerRawImageDataListener> listeners = new ArrayList<InnerRawImageDataListener>();

    public RawImageData getRawImageData();

    public static void addRawImageDataListener(RawImageDataListener listener, RawImageDataProvider provider) {
        listeners.add(new InnerRawImageDataListener(listener, provider));
    }

    public static void removeRawImageDataListener(RawImageDataListener listener) {
        ArrayList<InnerRawImageDataListener> toRemove = new ArrayList<InnerRawImageDataListener>();
        for (InnerRawImageDataListener inner : listeners) {
            if (inner.getListener() != listener) continue;
            toRemove.add(inner);
        }
        for (InnerRawImageDataListener inner : toRemove) {
            listeners.remove(inner);
        }
    }

    public static void notifyRawImageDataListeners(RawImageDataProvider dataProvider) {
        for (InnerRawImageDataListener l : listeners) {
            if (l.getProvider() != dataProvider) continue;
            l.getListener().rawImageDataAvailable(dataProvider);
        }
    }

    public static class InnerRawImageDataListener {
        final RawImageDataListener listener;
        final RawImageDataProvider provider;

        InnerRawImageDataListener(RawImageDataListener listener, RawImageDataProvider provider) {
            this.listener = listener;
            this.provider = provider;
        }

        RawImageDataListener getListener() {
            return this.listener;
        }

        RawImageDataProvider getProvider() {
            return this.provider;
        }
    }
}

