/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataProvider;

public class Reb
extends Geometry<CCD>
implements RawImageDataProvider {
    private final int sensorGap = 10;
    private static final RawImageData.BitsPerPixel bits = RawImageData.BitsPerPixel.BIT32;

    public Reb(String name) {
        super(name, 3, 1);
    }

    @Override
    protected void addGeometryToGrid(CCD child, int s, int p) {
        if (p != 0) {
            throw new IllegalArgumentException("Rebs only allow one row of CCDs in it");
        }
        int xCoord = s * child.getWidth();
        this.addGeometry(child, xCoord += s * 10, 0);
    }

    public static Reb createReb(String label, int row, CCDType type) {
        Reb reb = new Reb(label);
        for (int i = 0; i < 3; ++i) {
            String ccdLabel = "Sen" + row + i;
            CCD ccd = CCD.createCCD(ccdLabel, type);
            reb.addChildGeometry(ccd, i, 0);
        }
        return reb;
    }

    @Override
    public RawImageData getRawImageData() {
        int totalSize = 0;
        ArrayList<ByteBuffer> availableData = new ArrayList<ByteBuffer>();
        int segCount = 0;
        for (int s = 0; s < this.getSerialChildrenCount(); ++s) {
            CCD ccd = (CCD)this.getChild(s, 0);
            for (SegmentInterface segment : ccd.getSegments()) {
                RawImageData imageData = ((Segment)segment).getRawImageData();
                availableData.add(imageData.getImageData());
                totalSize += imageData.getImageData().limit();
                ++segCount;
            }
        }
        ByteBuffer result = ByteBuffer.allocateDirect(totalSize);
        result.order(ByteOrder.nativeOrder());
        int segmentData = totalSize / segCount / bits.bytes();
        for (int i = 0; i < segmentData; ++i) {
            for (ByteBuffer byteBuffer : availableData) {
                result.putInt(byteBuffer.getInt());
            }
        }
        result.flip();
        return new RawImageData(bits, result);
    }
}

