/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.SegmentInterface;

public interface CCDTransform {
    public void setXY(int var1, int var2);

    public int getX();

    public int getY();

    public void setSegmentSerialParallel(SegmentInterface var1, int var2, int var3);

    public SegmentInterface getSegment();

    public int getSerial();

    public int getParallel();

    public PixelType getPixelType();

    public int getGlobalX();

    public int getGlobalY();

    public static CCDTransform getGlobalTransform(CCDInterface ccd) {
        return new GlobalTransform(ccd);
    }

    public static CCDTransform getActiveTransform(CCDInterface ccd) {
        return new ActiveTransform(ccd);
    }

    public static class GlobalTransform
    implements CCDTransform {
        private SegmentInterface segment;
        private int serial;
        private int parallel;
        private PixelType pixelType;
        private int x;
        private int y;
        private final CCDInterface ccd;

        GlobalTransform(CCDInterface ccd) {
            this.ccd = ccd;
        }

        @Override
        public void setXY(int x, int y) {
            assert (x >= 0 && x < this.ccd.getTotalSerialSize());
            assert (y >= 0 && y < this.ccd.getTotalParallelSize());
            this.x = x;
            this.y = y;
            int column = x / this.ccd.getType().getSegmentTotalSerialSize();
            int row = y / this.ccd.getType().getSegmentTotalParallelSize();
            this.segment = this.ccd.getSegment(column, row);
            this.parallel = this.segment.isReadoutDown() ? y : this.ccd.getType().getSegmentTotalParallelSize() - 1 - (y %= this.ccd.getType().getSegmentTotalParallelSize());
            int n = this.serial = this.segment.isReadoutLeft() ? x : this.ccd.getType().getSegmentTotalSerialSize() - 1 - (x %= this.ccd.getType().getSegmentTotalSerialSize());
            this.pixelType = this.parallel > this.segment.getSegmentParallelActiveSize() ? PixelType.PARALLEL_OVERSCAN : (this.serial < this.segment.getSegmentSerialPrescanSize() ? PixelType.SERIAL_PRESCAN : (this.serial > this.segment.getSegmentSerialPrescanSize() + this.segment.getSegmentSerialActiveSize() ? PixelType.SERIAL_OVERSCAN : PixelType.ACTIVE));
        }

        @Override
        public void setSegmentSerialParallel(SegmentInterface segment, int serial, int parallel) {
            assert (segment.getParentCCD() == this.ccd);
            assert (0 <= parallel && parallel < this.ccd.getType().getSegmentTotalParallelSize());
            assert (0 <= serial && serial < this.ccd.getType().getSegmentTotalSerialSize());
            this.segment = segment;
            this.serial = serial;
            this.parallel = parallel;
            this.pixelType = parallel > segment.getSegmentParallelActiveSize() ? PixelType.PARALLEL_OVERSCAN : (serial < segment.getSegmentSerialPrescanSize() ? PixelType.SERIAL_PRESCAN : (serial > segment.getSegmentSerialPrescanSize() + segment.getSegmentSerialActiveSize() ? PixelType.SERIAL_OVERSCAN : PixelType.ACTIVE));
            int xx = segment.isReadoutLeft() ? serial : this.ccd.getType().getSegmentTotalSerialSize() - 1 - serial;
            int yy = segment.isReadoutDown() ? parallel : this.ccd.getType().getSegmentTotalParallelSize() - 1 - parallel;
            this.x = xx += segment.getSerialPosition() * this.ccd.getType().getSegmentTotalSerialSize();
            this.y = yy += segment.getParallelPosition() * this.ccd.getType().getSegmentTotalParallelSize();
        }

        @Override
        public SegmentInterface getSegment() {
            return this.segment;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }

        @Override
        public int getParallel() {
            return this.parallel;
        }

        @Override
        public PixelType getPixelType() {
            return this.pixelType;
        }

        public String toString() {
            return "GlobalTransform{segment=" + this.segment + ", serial=" + this.serial + ", parallel=" + this.parallel + ", pixelType=" + (Object)((Object)this.pixelType) + ", x=" + this.x + ", y=" + this.y + '}';
        }

        @Override
        public int getGlobalX() {
            return this.x;
        }

        @Override
        public int getGlobalY() {
            return this.y;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }
    }

    public static class ActiveTransform
    implements CCDTransform {
        private SegmentInterface segment;
        private int serial;
        private int parallel;
        private int x;
        private int y;
        private int globalX;
        private int globalY;
        private final CCDInterface ccd;

        ActiveTransform(CCDInterface ccd) {
            this.ccd = ccd;
        }

        @Override
        public void setXY(int x, int y) {
            assert (x >= 0 && x < this.ccd.getActiveSerialSize());
            assert (y >= 0 && y < this.ccd.getActiveParallelSize());
            this.x = x;
            this.y = y;
            int column = x / this.ccd.getType().getSegmentSerialActiveSize();
            int row = y / this.ccd.getType().getSegmentParallelActiveSize();
            this.segment = this.ccd.getSegment(column, row);
            this.globalX = x + this.segment.getSerialPosition() * (this.segment.getSegmentSerialPrescanSize() + this.segment.getSegmentSerialOverscanSize()) + (!this.segment.isReadoutLeft() ? this.segment.getSegmentSerialPrescanSize() : this.segment.getSegmentSerialOverscanSize());
            this.globalY = y + this.segment.getParallelPosition() * this.segment.getSegmentParallelOverscanSize() + (this.segment.isReadoutDown() ? 0 : this.segment.getSegmentParallelOverscanSize());
            this.serial = this.segment.getSegmentSerialPrescanSize() + (!this.segment.isReadoutLeft() ? x : this.segment.getSegmentSerialActiveSize() - 1 - (x %= this.segment.getSegmentSerialActiveSize()));
            this.parallel = this.segment.isReadoutDown() ? y : this.segment.getSegmentParallelActiveSize() - 1 - (y %= this.segment.getSegmentParallelActiveSize());
        }

        @Override
        public SegmentInterface getSegment() {
            return this.segment;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }

        @Override
        public int getParallel() {
            return this.parallel;
        }

        @Override
        public PixelType getPixelType() {
            return PixelType.ACTIVE;
        }

        @Override
        public int getGlobalX() {
            return this.globalX;
        }

        @Override
        public int getGlobalY() {
            return this.globalY;
        }

        public String toString() {
            return "ActiveTransform{segment=" + this.segment + ", serial=" + this.serial + ", parallel=" + this.parallel + ", x=" + this.x + ", y=" + this.y + '}';
        }

        @Override
        public void setSegmentSerialParallel(SegmentInterface segment, int serial, int parallel) {
            assert (segment.getParentCCD() == this.ccd);
            assert (0 <= parallel && parallel < segment.getSegmentParallelActiveSize());
            assert (segment.getSegmentSerialPrescanSize() <= serial && serial < segment.getSegmentSerialPrescanSize() + segment.getSegmentSerialActiveSize());
            this.segment = segment;
            this.serial = serial;
            this.parallel = parallel;
            int yy = segment.isReadoutDown() ? parallel : segment.getSegmentParallelActiveSize() - 1 - parallel;
            int xx = !segment.isReadoutLeft() ? serial : segment.getSegmentSerialActiveSize() - 1 - (serial -= segment.getSegmentSerialPrescanSize());
            this.x = xx += segment.getSerialPosition() * segment.getSegmentSerialActiveSize();
            this.y = yy += segment.getParallelPosition() * segment.getSegmentParallelActiveSize();
            this.globalX = this.x + segment.getSerialPosition() * (segment.getSegmentSerialPrescanSize() + segment.getSegmentSerialOverscanSize()) + (!segment.isReadoutLeft() ? segment.getSegmentSerialPrescanSize() : segment.getSegmentSerialOverscanSize());
            this.globalY = this.y + segment.getParallelPosition() * segment.getSegmentParallelOverscanSize() + (segment.isReadoutDown() ? 0 : segment.getSegmentParallelOverscanSize());
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }
    }

    public static enum PixelType {
        ACTIVE,
        SERIAL_PRESCAN,
        SERIAL_OVERSCAN,
        PARALLEL_OVERSCAN;

    }
}

