/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.SegmentInterface;

public class CCD
extends Geometry<Segment>
implements CCDInterface {
    private final CCDType ccdType;
    private final List<SegmentInterface> segments = new ArrayList<SegmentInterface>();

    public CCD(String label, CCDType ccdType) {
        this(8, 2, ccdType, label);
    }

    CCD(int serialSegmentsCount, int parallelSegmentsCount, CCDType ccdType, String name) {
        super(name, serialSegmentsCount, parallelSegmentsCount);
        this.ccdType = ccdType;
    }

    @Override
    protected void addGeometryToGrid(Segment segment, int s, int p) {
        this.addGeometry(segment, s * segment.getWidth(), (this.getParallelChildrenCount() - p - 1) * segment.getHeight());
        this.segments.add(segment);
        Collections.sort(this.segments, (o1, o2) -> o1.getChannel() > o2.getChannel() ? 1 : -1);
    }

    @Override
    public int getTotalSerialSize() {
        return this.ccdType.getSegmentTotalSerialSize() * this.getSerialChildrenCount();
    }

    @Override
    public int getActiveSerialSize() {
        return this.ccdType.getSegmentSerialActiveSize() * this.getSerialChildrenCount();
    }

    @Override
    public int getTotalParallelSize() {
        return this.ccdType.getSegmentTotalParallelSize() * this.getParallelChildrenCount();
    }

    @Override
    public int getActiveParallelSize() {
        return this.ccdType.getSegmentParallelActiveSize() * this.getParallelChildrenCount();
    }

    @Override
    public SegmentInterface getSegment(int s, int p) {
        return (SegmentInterface)this.getChild(s, p);
    }

    @Override
    public CCDType getType() {
        return this.ccdType;
    }

    @Override
    public List<SegmentInterface> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    @Override
    public int getParallelSegmentCount() {
        return this.getParallelChildrenCount();
    }

    @Override
    public int getSerialSegmentCount() {
        return this.getSerialChildrenCount();
    }

    public static CCD createCCD(String label, CCDType ccdType) {
        CCD ccd = new CCD(label, ccdType);
        for (int s = 0; s < ccd.getSerialChildrenCount(); ++s) {
            for (int p = 0; p < ccd.getParallelChildrenCount(); ++p) {
                int channel = p == 0 ? 16 - s : 1 + s;
                Segment segment = Segment.createCCDSegment(ccdType, "Seg" + p + s, s, p, channel);
                ccd.addChildGeometry(segment, s, p);
            }
        }
        return ccd;
    }
}

