/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.data;

import java.nio.ByteBuffer;
import java.text.ParseException;
import junit.framework.TestCase;
import org.junit.Test;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

public class RawDataTest {
    @Test
    public void testRebRawData() throws ParseException {
        Raft raftGeometry = Raft.createRaft((String)"R00", (CCDType)CCDType.TEST_SMALL_E2V);
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)raftGeometry, (String)"image", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)raftGeometry, (GeneratedImage)generatedImage);
        for (Reb reb : raftGeometry.getChildrenList()) {
            ByteBuffer rawData = reb.getRawImageData().getImageData();
            CCD ccd = (CCD)reb.getChild(0, 0);
            int ccdSize = ccd.getTotalParallelSize() * ccd.getTotalSerialSize();
            TestCase.assertEquals((int)rawData.capacity(), (int)(ccdSize * 3 * 4));
            for (int i = 0; i < rawData.capacity() / 4; ++i) {
                rawData.getInt();
            }
        }
    }
}

