/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.Test;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDTransform;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;

public class CCDTypeTest {
    @Test
    public void testE2V() {
        CCDType type = CCDType.E2V;
        CCDGeometry geometry = type.getGeometry();
        this.testE2VInterface((CCDInterface)geometry);
    }

    @Test
    public void testE2VNew() {
        CCDType type = CCDType.E2V;
        CCD geometry = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testE2VInterface((CCDInterface)geometry);
    }

    public void testE2VInterface(CCDInterface ccd) {
        Map primaryHeaders = FitsHeaderUtilities.getCCDPrimaryHeaders((CCDInterface)ccd);
        TestCase.assertEquals((Object)"[1:4096,1:4004]", primaryHeaders.get("DETSIZE"));
        List segments = ccd.getSegments();
        Map header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(0)));
        TestCase.assertEquals((Object)"Segment10", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[512:1,4004:2003]", header.get("DETSEC"));
        TestCase.assertEquals((Object)545.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(1)));
        TestCase.assertEquals((Object)"Segment11", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[1024:513,4004:2003]", header.get("DETSEC"));
        TestCase.assertEquals((Object)1089.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(2)));
        TestCase.assertEquals((Object)"Segment12", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[1536:1025,4004:2003]", header.get("DETSEC"));
        TestCase.assertEquals((Object)1633.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(3)));
        TestCase.assertEquals((Object)"Segment13", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[2048:1537,4004:2003]", header.get("DETSEC"));
        TestCase.assertEquals((Object)2177.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(4)));
        TestCase.assertEquals((Object)"Segment14", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[2560:2049,4004:2003]", header.get("DETSEC"));
        TestCase.assertEquals((Object)2721.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(5)));
        TestCase.assertEquals((Object)"Segment15", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[3072:2561,4004:2003]", header.get("DETSEC"));
        TestCase.assertEquals((Object)3265.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(6)));
        TestCase.assertEquals((Object)"Segment16", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[3584:3073,4004:2003]", header.get("DETSEC"));
        TestCase.assertEquals((Object)3809.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(7)));
        TestCase.assertEquals((Object)"Segment17", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[4096:3585,4004:2003]", header.get("DETSEC"));
        TestCase.assertEquals((Object)4353.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(8)));
        TestCase.assertEquals((Object)"Segment07", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[3585:4096,1:2002]", header.get("DETSEC"));
        TestCase.assertEquals((Object)-3808.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(9)));
        TestCase.assertEquals((Object)"Segment06", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[3073:3584,1:2002]", header.get("DETSEC"));
        TestCase.assertEquals((Object)-3264.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(10)));
        TestCase.assertEquals((Object)"Segment05", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[2561:3072,1:2002]", header.get("DETSEC"));
        TestCase.assertEquals((Object)-2720.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(11)));
        TestCase.assertEquals((Object)"Segment04", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[2049:2560,1:2002]", header.get("DETSEC"));
        TestCase.assertEquals((Object)-2176.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(12)));
        TestCase.assertEquals((Object)"Segment03", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[1537:2048,1:2002]", header.get("DETSEC"));
        TestCase.assertEquals((Object)-1632.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(13)));
        TestCase.assertEquals((Object)"Segment02", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[1025:1536,1:2002]", header.get("DETSEC"));
        TestCase.assertEquals((Object)-1088.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(14)));
        TestCase.assertEquals((Object)"Segment01", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[513:1024,1:2002]", header.get("DETSEC"));
        TestCase.assertEquals((Object)-544.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllE2V(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(15)));
        TestCase.assertEquals((Object)"Segment00", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[1:512,1:2002]", header.get("DETSEC"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllE2V(header);
    }

    private void testAllE2V(Map<String, Object> header) {
        TestCase.assertEquals((Object)"[11:522,1:2002]", (Object)header.get("DATASEC"));
        TestCase.assertEquals((Object)"[523:544,1:2002]", (Object)header.get("BIASSEC"));
    }

    @Test
    public void testITLNew() {
        CCDType type = CCDType.ITL;
        CCD geometry = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testITLInterface((CCDInterface)geometry);
    }

    @Test
    public void testITL() {
        CCDType type = CCDType.ITL;
        CCDGeometry geometry = type.getGeometry();
        this.testITLInterface((CCDInterface)geometry);
    }

    public void testITLInterface(CCDInterface ccd) {
        Map primaryHeaders = FitsHeaderUtilities.getCCDPrimaryHeaders((CCDInterface)ccd);
        TestCase.assertEquals((Object)"[1:4072,1:4000]", primaryHeaders.get("DETSIZE"));
        List segments = ccd.getSegments();
        Map header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(0)));
        TestCase.assertEquals((Object)"Segment10", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[509:1,4000:2001]", header.get("DETSEC"));
        TestCase.assertEquals((Object)545.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(1)));
        TestCase.assertEquals((Object)"Segment11", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[1018:510,4000:2001]", header.get("DETSEC"));
        TestCase.assertEquals((Object)1089.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(2)));
        TestCase.assertEquals((Object)"Segment12", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[1527:1019,4000:2001]", header.get("DETSEC"));
        TestCase.assertEquals((Object)1633.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(3)));
        TestCase.assertEquals((Object)"Segment13", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[2036:1528,4000:2001]", header.get("DETSEC"));
        TestCase.assertEquals((Object)2177.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(4)));
        TestCase.assertEquals((Object)"Segment14", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[2545:2037,4000:2001]", header.get("DETSEC"));
        TestCase.assertEquals((Object)2721.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(5)));
        TestCase.assertEquals((Object)"Segment15", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[3054:2546,4000:2001]", header.get("DETSEC"));
        TestCase.assertEquals((Object)3265.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(6)));
        TestCase.assertEquals((Object)"Segment16", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[3563:3055,4000:2001]", header.get("DETSEC"));
        TestCase.assertEquals((Object)3809.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(7)));
        TestCase.assertEquals((Object)"Segment17", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[4072:3564,4000:2001]", header.get("DETSEC"));
        TestCase.assertEquals((Object)4353.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)4097.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)-1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(8)));
        TestCase.assertEquals((Object)"Segment07", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[4072:3564,1:2000]", header.get("DETSEC"));
        TestCase.assertEquals((Object)4353.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(9)));
        TestCase.assertEquals((Object)"Segment06", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[3563:3055,1:2000]", header.get("DETSEC"));
        TestCase.assertEquals((Object)3809.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(10)));
        TestCase.assertEquals((Object)"Segment05", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[3054:2546,1:2000]", header.get("DETSEC"));
        TestCase.assertEquals((Object)3265.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(11)));
        TestCase.assertEquals((Object)"Segment04", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[2545:2037,1:2000]", header.get("DETSEC"));
        TestCase.assertEquals((Object)2721.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(12)));
        TestCase.assertEquals((Object)"Segment03", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[2036:1528,1:2000]", header.get("DETSEC"));
        TestCase.assertEquals((Object)2177.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(13)));
        TestCase.assertEquals((Object)"Segment02", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[1527:1019,1:2000]", header.get("DETSEC"));
        TestCase.assertEquals((Object)1633.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(14)));
        TestCase.assertEquals((Object)"Segment01", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[1018:510,1:2000]", header.get("DETSEC"));
        TestCase.assertEquals((Object)1089.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllITL(header);
        header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)((SegmentInterface)segments.get(15)));
        TestCase.assertEquals((Object)"Segment00", header.get("EXTNAME"));
        TestCase.assertEquals((Object)"[509:1,1:2000]", header.get("DETSEC"));
        TestCase.assertEquals((Object)545.0, header.get("CRPIX1"));
        TestCase.assertEquals((Object)0.0, header.get("CRPIX2"));
        TestCase.assertEquals((Object)-1.0, header.get("CD1_1"));
        TestCase.assertEquals((Object)1.0, header.get("CD2_2"));
        this.testAllITL(header);
    }

    private void testAllITL(Map<String, Object> header) {
        TestCase.assertEquals((Object)"[4:512,1:2000]", (Object)header.get("DATASEC"));
        TestCase.assertEquals((Object)"[513:544,1:2000]", (Object)header.get("BIASSEC"));
    }

    @Test
    public void testE2VGlobalTranform() {
        CCDType type = CCDType.E2V;
        CCDGeometry ccd = type.getGeometry();
        this.testGlobalTransform((CCDInterface)ccd);
        CCD ccd1 = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testGlobalTransform((CCDInterface)ccd1);
    }

    @Test
    public void testITLGlobalTranform() {
        CCDType type = CCDType.ITL;
        CCDGeometry ccd = type.getGeometry();
        this.testGlobalTransform((CCDInterface)ccd);
        CCD ccd1 = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testGlobalTransform((CCDInterface)ccd1);
    }

    @Test
    public void testE2VActiveTranform() {
        CCDType type = CCDType.E2V;
        CCDGeometry ccd = type.getGeometry();
        this.testActiveTransform((CCDInterface)ccd);
        CCD ccd1 = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testActiveTransform((CCDInterface)ccd1);
    }

    @Test
    public void testITLActiveTranform() {
        CCDType type = CCDType.ITL;
        CCDGeometry ccd = type.getGeometry();
        this.testActiveTransform((CCDInterface)ccd);
        CCD ccd1 = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testActiveTransform((CCDInterface)ccd1);
    }

    private void testActiveTransform(CCDInterface ccd) {
        CCDTransform local1 = CCDTransform.getActiveTransform((CCDInterface)ccd);
        CCDTransform local2 = CCDTransform.getActiveTransform((CCDInterface)ccd);
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            int x = r.nextInt(ccd.getActiveSerialSize());
            int y = r.nextInt(ccd.getActiveParallelSize());
            local1.setXY(x, y);
            local2.setSegmentSerialParallel(local1.getSegment(), local1.getSerial(), local1.getParallel());
            this.testEqual(local1, local2);
        }
    }

    private void testGlobalTransform(CCDInterface ccd) {
        CCDTransform global1 = CCDTransform.getGlobalTransform((CCDInterface)ccd);
        CCDTransform global2 = CCDTransform.getGlobalTransform((CCDInterface)ccd);
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            int x = r.nextInt(ccd.getTotalSerialSize());
            int y = r.nextInt(ccd.getTotalParallelSize());
            global1.setXY(x, y);
            global2.setSegmentSerialParallel(global1.getSegment(), global1.getSerial(), global1.getParallel());
            this.testEqual(global1, global2);
        }
    }

    private void testEqual(CCDTransform global1, CCDTransform global2) {
        TestCase.assertEquals((int)global1.getX(), (int)global2.getX());
        TestCase.assertEquals((int)global1.getY(), (int)global2.getY());
        TestCase.assertEquals((int)global1.getGlobalX(), (int)global2.getGlobalX());
        TestCase.assertEquals((int)global1.getGlobalY(), (int)global2.getGlobalY());
        TestCase.assertEquals((Object)global1.getSegment(), (Object)global2.getSegment());
        TestCase.assertEquals((int)global1.getSerial(), (int)global2.getSerial());
        TestCase.assertEquals((int)global1.getParallel(), (int)global2.getParallel());
        TestCase.assertEquals((Object)global1.getPixelType(), (Object)global2.getPixelType());
    }

    @Test
    public void testDumpHeaders() {
        for (CCDType type : CCDType.values()) {
            for (SegmentInterface segment : type.getGeometry().getSegments()) {
                System.out.println(FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)segment));
            }
        }
    }
}

