/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rafts.demo;

import java.io.File;
import java.io.IOException;
import nom.tam.fits.FitsException;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProviderFactory;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.GeometryFitsHeaderMetadataProviderFactory;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

public class RaftsDemoNew {
    public static void main(String[] args) throws InterruptedException, IOException, FitsException {
        FitsHeadersSpecifications.addSpecFile((String)"primary");
        FitsHeadersSpecifications.addSpecFile((String)"extended");
        FitsHeadersSpecifications.addSpecFile((String)"test_cond");
        CCDType type = CCDType.TEST_SMALL_E2V;
        Raft raft = Raft.createRaft((String)"raft00", (CCDType)type);
        GeometryFitsHeaderMetadataProviderFactory factory = new GeometryFitsHeaderMetadataProviderFactory((Geometry)raft);
        FitsFileWriter.setFitsHeaderMetadataProviderFactory((FitsHeaderMetadataProviderFactory)factory);
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)raft, (String)"ripples", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)raft, (GeneratedImage)generatedImage);
        for (int rebId = 0; rebId < raft.getParallelChildrenCount(); ++rebId) {
            Reb reb = (Reb)raft.getChild(0, rebId);
            System.out.println("Processing reb " + reb.getName() + " (0," + rebId + ")");
            for (int ccdId = 0; ccdId < 3; ++ccdId) {
                CCD ccd = (CCD)reb.getChild(ccdId, 0);
                String raftName = String.format("R99_S%d%d", rebId, ccdId);
                File raftFile = new File("/tmp/" + raftName + ".fits");
                ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD((CCDInterface)ccd);
                FitsFileWriter ffw = new FitsFileWriter(raftFile, imageSet);
                for (SegmentInterface segment : ccd.getSegments()) {
                    ffw.write(segment.getChannel() - 1, ((Segment)segment).getRawImageData().getImageData());
                }
            }
        }
    }
}

