/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rafts.demo;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import nom.tam.fits.FitsException;
import org.lsst.ccs.rafts.demo.RawImageConverter;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.ImageSet;

public class RaftsDemo {
    public static void main(String[] args) throws InterruptedException, IOException, FitsException {
        FitsHeadersSpecifications.addSpecFile((String)"primary");
        FitsHeadersSpecifications.addSpecFile((String)"extended");
        FitsHeadersSpecifications.addSpecFile((String)"test_cond");
        CCDType type = CCDType.TEST_SMALL_E2V;
        CCDGeometry geometry = type.getGeometry();
        ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD((CCDInterface)geometry);
        int raftGapInPixels = 100;
        int totalHeight = 3 * geometry.getActiveSerialSize() + 2 * raftGapInPixels;
        int totalWidth = 3 * geometry.getActiveParallelSize() + 2 * raftGapInPixels;
        BufferedImage image = RaftsDemo.createRippledImage(totalWidth, totalHeight);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                String raftName = String.format("R99_S%d%d", x, y);
                File raftFile = new File("/tmp/" + raftName + ".fits");
                System.out.println(raftName);
                Map primaryHeaders = FitsHeaderUtilities.getCCDPrimaryHeaders((CCDInterface)geometry);
                primaryHeaders.put("Raft", primaryHeaders);
                int raftOffsetX = x * (raftGapInPixels + geometry.getActiveParallelSize());
                int raftOffsetY = y * (raftGapInPixels + geometry.getActiveSerialSize());
                BufferedImage ccdImage = image.getSubimage(raftOffsetX, raftOffsetY, geometry.getActiveParallelSize(), geometry.getActiveSerialSize());
                RawImageConverter ric = new RawImageConverter(ccdImage, (CCDInterface)geometry, raftOffsetX, raftOffsetY);
                try (FitsFileWriter ffw = new FitsFileWriter(raftFile, ric.getImageSet());){
                    ric.pushDataToFile(ffw);
                    continue;
                }
            }
        }
    }

    private static BufferedImage createRippledImage(int totalWidth, int totalHeight) {
        BufferedImage image = new BufferedImage(totalWidth, totalHeight, 11);
        WritableRaster raster = image.getRaster();
        for (int i = 0; i < totalWidth; ++i) {
            for (int j = 0; j < totalHeight; ++j) {
                double r = Math.sqrt(Math.pow(j - totalHeight / 2, 2.0) + Math.pow(i - totalWidth / 2, 2.0));
                short val = (short)Math.round(1000.0 + 200.0 * Math.sin(r / 30.0));
                raster.setSample(i, j, 0, val);
            }
        }
        return image;
    }
}

