/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rafts.demo;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import nom.tam.fits.FitsException;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProviderFactory;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.GeometryFitsHeaderMetadataProviderFactory;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

public class CCDDemo {
    public static void main(String[] args) throws InterruptedException, IOException, FitsException {
        FitsHeadersSpecifications.addSpecFile((String)"primary");
        FitsHeadersSpecifications.addSpecFile((String)"extended");
        FitsHeadersSpecifications.addSpecFile((String)"test_cond");
        CCDType type = CCDType.TEST_SMALL_E2V;
        CCD ccd = CCD.createCCD((String)"sensor00", (CCDType)type);
        GeometryFitsHeaderMetadataProviderFactory factory = new GeometryFitsHeaderMetadataProviderFactory((Geometry)ccd);
        FitsFileWriter.setFitsHeaderMetadataProviderFactory((FitsHeaderMetadataProviderFactory)factory);
        CCDDemo.writeFitsFile(ccd);
        type = CCDType.TEST_SMALL_ITL;
        ccd = CCD.createCCD((String)"sensor00", (CCDType)type);
        GeometryFitsHeaderMetadataProviderFactory factory1 = new GeometryFitsHeaderMetadataProviderFactory((Geometry)ccd);
        FitsFileWriter.setFitsHeaderMetadataProviderFactory((FitsHeaderMetadataProviderFactory)factory1);
        CCDDemo.writeFitsFile(ccd);
    }

    private static void writeFitsFile(CCD ccd) throws InterruptedException, IOException, FitsException {
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)ccd, (String)"ripples", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)ccd, (GeneratedImage)generatedImage);
        String raftName = String.format(ccd.getType().name() + "S%d%d", 0, 0);
        File raftFile = new File("/tmp/" + raftName + ".fits");
        Map primaryHeaders = FitsHeaderUtilities.getCCDPrimaryHeaders((CCDInterface)ccd);
        primaryHeaders.put("Raft", primaryHeaders);
        ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD((CCDInterface)ccd);
        FitsFileWriter ffw = new FitsFileWriter(raftFile, imageSet);
        for (SegmentInterface segment : ccd.getSegments()) {
            ffw.write(segment.getChannel() - 1, ((Segment)segment).getRawImageData().getImageData());
        }
    }
}

