
package org.lsst.ccs.utilities.image.patterns;

import java.io.Serializable;
import org.lsst.ccs.utilities.image.ImagePixelData;

/**
 * An Image generated by PatternGenerators.
 * 
 * @author turri
 */
public class GeneratedImage implements Serializable, ImagePixelData {
    
    private final int[][] data;
    private final double maxValue;
    
    public GeneratedImage(int[][] data, double maxValue) {
        this.data = data;
        this.maxValue = maxValue;        
    }

    @Override
    public int getWidth() {
        return data.length;
    }

    @Override
    public int getHeight() {
        return data[0].length;
    }

    @Override
    public int getPixelData(int x, int y) {
        return data[x][y];
    }
        
    /**
     * Get the maximum value of the contained data.
     * This is used so that we can render the image on the screen in ray scale.
     * 
     * @return The max value of the data if available. Double.NaN otherwise.
     */
    public double getMaxValue() {
        return maxValue;
    }
        
}
