
package org.lsst.ccs.utilities.image;

/**
 * A factory that generates FitsHeaderMetadataProvider objects when
 * FitsFileWriters are in the process of writing out an image.
 * 
 * @author turri
 */
public interface FitsHeaderMetadataProviderFactory {
    
    /**
     * Create a FitsHeaderMetadataProvider for the given ImageSet
     * 
     * @param imageSet The ImageSet object for which to create the FitsHeaderMetadataProvider.
     * 
     * @return The metadata for the primary header
     */
    public FitsHeaderMetadataProvider createFitsHeaderMetadataProvider(ImageSet imageSet);    
}
