package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.geometry.Geometry;

public class Raft extends Geometry<Reb> {

    private final int rebGap = 10;

    public Raft(String name) {
        super(name, 1, 3);
    }

    @Override
    protected void addGeometryToGrid(Reb child, int s, int p) {
        if (s != 0) {
            throw new IllegalArgumentException("Rafts can only accept Reb children in the parallel direction.");
        }
        int yCoord = (2-p) * child.getHeight();
        yCoord += (2-p) * rebGap;
        addGeometry(child, 0, yCoord);
    }

    public static Raft createRaft(String label, CCDType type) {
        Raft raft = new Raft(label);
        //Add three Rebs top to bottom
        for (int i = 2; i >= 0; i--) {
            String rebLabel = "Reb" + i;
            Reb reb = Reb.createReb(rebLabel, i, type);
            raft.addChildGeometry(reb, 0, i);
        }
        return raft;
    }

}
