
package org.lsst.ccs.geometry;

import org.lsst.ccs.utilities.image.ImagePixelData;


/**
 * Interface to be implemented by Geometry objects that can be exposed to 
 * a ImagePixelData.
 * 
 * @author turri
 */
public interface ImageSensitiveArea {
    
    /**
     * Expose the current object to the ImagePixelData.
     * 
     * @param imagePixelData
     */
    public void exposeToImage(ImagePixelData imagePixelData);
    
    
    /**
     * Check if this object has data.
     * 
     * @return true if there is data.
     */
    public boolean hasPixelData();

    
    /**
     * Get the ImagePixelData for this object, if present. Null otherwise.
     * 
     * @return the accumulated ImagePixelData.
     */
    public ImagePixelData getImagePixelData();
}
