/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.patterns;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.geometry.ImageSensitiveArea;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataProvider;
import org.lsst.ccs.utilities.image.patterns.CheckeredPatternGenerator;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.ImagePatternGenerator;
import org.lsst.ccs.utilities.image.patterns.NoisePatternGenerator;
import org.lsst.ccs.utilities.image.patterns.PatternGenerator;
import org.lsst.ccs.utilities.image.patterns.RipplesPatternGenerator;

public class PatternGeneratorFactory {
    private static final HashMap<String, Class> patterns = new HashMap();

    public static Set<String> listAvailablePatterns() {
        return patterns.keySet();
    }

    public static PatternGenerator createPatternGenerator(String name) {
        if (!patterns.containsKey(name)) {
            throw new RuntimeException("Pattern \"" + name + "\" does not exist");
        }
        try {
            return (PatternGenerator)patterns.get(name).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not create PatterGenerator for \"" + name + "\".", e);
        }
    }

    private static void registerPatternGenerator(Class patternGeneratorClass) {
        try {
            PatternGenerator instance = (PatternGenerator)patternGeneratorClass.newInstance();
            String name = instance.getName();
            if (patterns.containsKey(name)) {
                throw new IllegalArgumentException("PatternGenerator with name \"" + name + "\" is already registered");
            }
            patterns.put(name, patternGeneratorClass);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Could not register the pattern generator class " + patternGeneratorClass.getCanonicalName(), e);
        }
    }

    public static GeneratedImage generateImageForGeometry(Geometry<?> geometry, String imagePattern, Map<String, String> params) {
        if (geometry == null) {
            throw new RuntimeException("The Geometry cannot be null");
        }
        int width = geometry.getWidth();
        int height = geometry.getHeight();
        System.out.print("Generating image " + imagePattern + " " + width + "x" + height + " took ");
        long start = System.currentTimeMillis();
        PatternGenerator patternGenerator = PatternGeneratorFactory.createPatternGenerator(imagePattern);
        GeneratedImage img = patternGenerator.generateImage(width, height, params);
        int seconds = (int)((double)(System.currentTimeMillis() - start) / 1000.0);
        System.out.println(seconds + " seconds.");
        return img;
    }

    public static void exposeGeometryToGeneratedImage(Geometry<?> geometry, GeneratedImage generatedImage) {
        if (geometry instanceof ImageSensitiveArea) {
            ((ImageSensitiveArea)((Object)geometry)).exposeToImage(generatedImage);
        }
        for (Geometry child : geometry.getChildrenList()) {
            PatternGeneratorFactory.exposeGeometryToGeneratedImage(child, generatedImage);
        }
        if (geometry instanceof RawImageDataProvider) {
            RawImageDataProvider.notifyRawImageDataListeners((RawImageDataProvider)((Object)geometry));
        }
    }

    static {
        PatternGeneratorFactory.registerPatternGenerator(RipplesPatternGenerator.class);
        PatternGeneratorFactory.registerPatternGenerator(NoisePatternGenerator.class);
        PatternGeneratorFactory.registerPatternGenerator(CheckeredPatternGenerator.class);
        PatternGeneratorFactory.registerPatternGenerator(ImagePatternGenerator.class);
    }
}

