/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

public class MetaDataSet
extends HashMap<String, Map<String, Object>> {
    public void addProperties(String name, Properties props) {
        this.addMetaData(name, this.convertToMetaData(props));
    }

    public void addMetaData(String name, Map<String, Object> data) {
        Map<String, Object> meta = this.findOrCreateMetaData(name);
        meta.putAll(data);
    }

    public static Object getValue(Map<String, Map<String, Object>> metaDataSet, String name) {
        for (Map<String, Object> metaData : metaDataSet.values()) {
            Object result = metaData.get(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Object getValue(Map<String, Map<String, Object>> metaDataSet, String map, String name) {
        if (map == null) {
            return MetaDataSet.getValue(metaDataSet, name);
        }
        Map<String, Object> metaData = metaDataSet.get(map);
        if (metaData == null) {
            return null;
        }
        return metaData.get(name);
    }

    private Map<String, Object> findOrCreateMetaData(String name) {
        HashMap result = (HashMap)this.get(name);
        if (result == null) {
            result = new HashMap();
            this.put(name, result);
        }
        return result;
    }

    private Map<String, Object> convertToMetaData(Properties props) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object n : BootstrapResourceUtils.getAllKeysInProperties((Properties)props)) {
            String name = (String)n;
            String value = props.getProperty(name);
            result.put(name, this.convertToMetaData(value));
        }
        return result;
    }

    private Object convertToMetaData(String value) {
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException x) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException xx) {
                try {
                    return new FitsDate(value).toDate();
                }
                catch (FitsException xxx) {
                    if ("true".equalsIgnoreCase(value)) {
                        return Boolean.TRUE;
                    }
                    if ("false".equalsIgnoreCase(value)) {
                        return Boolean.FALSE;
                    }
                    return value;
                }
            }
        }
    }
}

