/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.DefaultFitsHeaderMetadataProviderFactory;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProviderFactory;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;

public class FitsFileWriter
implements Closeable {
    private static FitsHeaderMetadataProviderFactory metadataProviderFactory = new DefaultFitsHeaderMetadataProviderFactory();
    private BufferedFile bf;
    private ImageExtension[] imageExtensions;

    @Deprecated
    public FitsFileWriter(File file, ImageSet images, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config, RawImageData.BitsPerPixel bits) throws IOException, FitsException {
        this.initializeFitsFileWriter(file, images, metaData, config, bits);
    }

    private void initializeFitsFileWriter(File file, ImageSet images, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config, RawImageData.BitsPerPixel bits) throws IOException, FitsException {
        if (metadataProviderFactory == null) {
            throw new RuntimeException("Cannot invoke this constructor if a FitsHeaderMetadataProviderFactory is not registered with this FitsFileWriter object.");
        }
        FitsHeaderMetadataProvider provider = FitsFileWriter.getFitsHeaderMetadataProviderFactory().createFitsHeaderMetadataProvider(images);
        if (provider == null) {
            throw new RuntimeException("Could not create a FitsHeaderMetadataProvider object for ImageSet: " + images);
        }
        this.imageExtensions = new ImageExtension[images.getImages().size()];
        int[][] intDummyData = new int[1][1];
        short[][] shortDummyData = new short[1][1];
        Object[] tableDummyData = new Object[]{};
        Object dummyData = bits == RawImageData.BitsPerPixel.BIT16 ? shortDummyData : (Object)intDummyData;
        this.bf = new BufferedFile(file, "rw");
        FitsFactory.setUseHierarch(true);
        Map<String, Map<String, Object>> fullMetaData = provider.getPrimaryHeaderMetadata();
        Map<String, Object> imageSetMetadata = images.getMetaData();
        if (imageSetMetadata != null) {
            fullMetaData.put("imageSet", imageSetMetadata);
        }
        if (metaData != null) {
            for (String k : metaData.keySet()) {
                fullMetaData.put(k, metaData.get(k));
            }
        }
        BasicHDU<?> primary = BasicHDU.getDummyHDU();
        this.addMetaDataToHeader(primary, "primary", fullMetaData, config);
        FitsCheckSum.setChecksum(primary);
        primary.getHeader().write(this.bf);
        int i = 0;
        for (ImageSet.Image image : images.getImages()) {
            BasicHDU<?> hdu = FitsFactory.HDUFactory(dummyData);
            Map<String, Map<String, Object>> extendedMetadata = provider.getDataExtendedHeaderMetadata(i);
            Map<String, Map<String, Object>> imageMetadata = images.getImages().get(i).getMetaData();
            if (imageMetadata != null) {
                extendedMetadata.putAll(imageMetadata);
            }
            this.addMetaDataToHeader(hdu, "extended", extendedMetadata, config);
            if (bits == RawImageData.BitsPerPixel.BIT16) {
                hdu.addValue("BSCALE", 1.0, "Unsigned 16 bit data");
                hdu.addValue("BZERO", 32768, "Unsigned 16 bit data");
            }
            Header header = hdu.getHeader();
            header.setXtension("IMAGE");
            header.setNaxis(1, image.getWidth());
            header.setNaxis(2, image.getHeight());
            FitsCheckSum.setChecksum(hdu);
            long start = this.bf.getFilePointer();
            header.write(this.bf);
            long current = this.bf.getFilePointer();
            long imageSize = bits.bytes() * image.getWidth() * image.getHeight();
            this.bf.seek(this.bf.getFilePointer() + imageSize);
            FitsUtil.pad(this.bf, imageSize);
            this.imageExtensions[i++] = new ImageExtension(start, current, this.bf.getFilePointer(), header);
        }
        FitsFactory.setUseAsciiTables(false);
        for (String key : config.keySet()) {
            if ("primary".equals(key) || "extended".equals(key)) continue;
            BasicHDU<?> binary = FitsFactory.HDUFactory(tableDummyData);
            Map<String, Map<String, Object>> additionalMetaData = provider.getAdditionalExtendedHeaderMetadata(key);
            this.addMetaDataToHeader(binary, key, additionalMetaData, config);
            Header header = binary.getHeader();
            header.setXtension("BINTABLE");
            FitsCheckSum.setChecksum(binary);
            header.write(this.bf);
        }
    }

    public FitsFileWriter(File file, ImageSet images) throws IOException, FitsException {
        this(file, images, null, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, Map<String, Map<String, Object>> metaData) throws IOException, FitsException {
        this(file, images, metaData, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, Map<String, Map<String, Object>> metaData, RawImageData.BitsPerPixel bits) throws IOException, FitsException {
        this.initializeFitsFileWriter(file, images, metaData, FitsHeadersSpecifications.getHeaderSpecifications(), bits);
    }

    public void write(int imageIndex, ByteBuffer src) throws IOException {
        this.imageExtensions[imageIndex].write(src);
    }

    @Override
    public void close() throws IOException {
        for (ImageExtension imageExtension : this.imageExtensions) {
            imageExtension.updateDataSum();
        }
        this.bf.close();
    }

    private void addMetaDataToHeader(BasicHDU hdu, String specName, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config) throws HeaderCardException, IOException {
        HeaderSpecification spec = config.get(specName);
        if (spec == null) {
            throw new IOException("Missing specification for header: " + specName);
        }
        for (HeaderSpecification.HeaderLine header : spec.getHeaders()) {
            Object value = header.getValue(metaData);
            try {
                if (value == null) continue;
                switch (header.getDataType()) {
                    case Integer: {
                        hdu.addValue(header.getKeyword(), ((Number)value).intValue(), header.getComment());
                        break;
                    }
                    case Float: {
                        double data = ((Number)value).doubleValue();
                        if (!Double.isFinite(data)) {
                            throw new IllegalArgumentException("Can not store non-finite floating point in FITS file");
                        }
                        hdu.addValue(header.getKeyword(), data, header.getComment());
                        break;
                    }
                    case Boolean: {
                        hdu.addValue(header.getKeyword(), (Boolean)value, header.getComment());
                        break;
                    }
                    case Date: {
                        hdu.addValue(header.getKeyword(), DateUtils.convertDateToString((Date)value), header.getComment());
                        break;
                    }
                    case MJD: {
                        hdu.addValue(header.getKeyword(), DateUtils.convertDateToMJD((Date)value), header.getComment());
                        break;
                    }
                    default: {
                        hdu.addValue(header.getKeyword(), String.valueOf(value), header.getComment());
                    }
                }
            }
            catch (ClassCastException x) {
                throw new IOException(String.format("Meta-data header %s with value %s(%s) cannot be converted to type %s", new Object[]{header.getKeyword(), value, value.getClass(), header.getDataType()}));
            }
        }
    }

    public static void setFitsHeaderMetadataProviderFactory(FitsHeaderMetadataProviderFactory metadataProviderFactory) {
        FitsFileWriter.metadataProviderFactory = metadataProviderFactory;
    }

    public static FitsHeaderMetadataProviderFactory getFitsHeaderMetadataProviderFactory() {
        return metadataProviderFactory;
    }

    private class ImageExtension {
        private final long startPosition;
        private final long endPosition;
        private long currentPosition;
        private final FitsCheckSum.Checksum checkSum;
        private final Header header;

        private ImageExtension(long start, long current, long end, Header header) {
            this.startPosition = start;
            this.currentPosition = current;
            this.endPosition = end;
            this.header = header;
            this.checkSum = new FitsCheckSum.Checksum();
        }

        private void write(ByteBuffer src) throws IOException {
            int length = src.remaining();
            if ((long)length + this.currentPosition > this.endPosition) {
                throw new IOException("Too much data written for image " + length + " " + this.currentPosition + " " + this.endPosition);
            }
            FitsCheckSum.updateChecksum(src, this.checkSum);
            FitsFileWriter.this.bf.seek(this.currentPosition);
            if (src.hasArray()) {
                FitsFileWriter.this.bf.write(src.array(), src.arrayOffset() + src.position(), src.remaining());
                src.position(src.limit());
            } else {
                while (src.remaining() > 0) {
                    FitsFileWriter.this.bf.write(src.get());
                }
            }
            this.currentPosition += (long)length;
        }

        private void updateDataSum() throws IOException {
            try {
                FitsCheckSum.updateDataSum(this.header, this.checkSum.getCheckSum());
                FitsFileWriter.this.bf.seek(this.startPosition);
                this.header.write(FitsFileWriter.this.bf);
            }
            catch (FitsException ex) {
                throw new IOException("Unable to add datasum to header", ex);
            }
        }
    }
}

