/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCDGeometry;

public enum CCDType {
    E2V(10, 2002, 512, 22, 46, true),
    ITL(3, 2000, 509, 32, 48, false),
    TEST_SMALL_E2V(1, 200, 50, 10, 4, true),
    TEST_SMALL_ITL(1, 200, 50, 10, 5, false);

    private CCDGeometry ccdGeom;
    private static final int ROW_COUNT = 8;
    private static final int COLUMN_COUNT = 2;
    private final int serialActiveSize;
    private final int parallelActiveSize;
    private final int serialPrescanSize;
    private final int serialOverscanSize;
    private final int parallelOverscanSize;

    private CCDType(int prescan, int segmentWidth, int segmentHeight, int overscan, int parallelOverscan, boolean isE2V) {
        int i;
        this.serialActiveSize = segmentHeight;
        this.parallelActiveSize = segmentWidth;
        this.serialPrescanSize = prescan;
        this.serialOverscanSize = overscan;
        this.parallelOverscanSize = parallelOverscan;
        this.ccdGeom = new CCDGeometry(8, 2, segmentHeight, segmentWidth, prescan, overscan, parallelOverscan, this);
        for (i = 0; i < 8; ++i) {
            this.ccdGeom.addSegment(i + 1, i, 1, CCDGeometry.ReadoutOrder.UpRight);
        }
        for (i = 8; i < 16; ++i) {
            this.ccdGeom.addSegment(i + 1, 15 - i, 0, isE2V ? CCDGeometry.ReadoutOrder.DownLeft : CCDGeometry.ReadoutOrder.DownRight);
        }
    }

    public int getSegmentTotalSerialSize() {
        return this.getSegmentSerialActiveSize() + this.getSegmentSerialOverscanSize() + this.getSegmentSerialPrescanSize();
    }

    public int getSegmentSerialActiveSize() {
        return this.serialActiveSize;
    }

    public int getSegmentSerialPrescanSize() {
        return this.serialPrescanSize;
    }

    public int getSegmentSerialOverscanSize() {
        return this.serialOverscanSize;
    }

    public int getSegmentTotalParallelSize() {
        return this.getSegmentParallelActiveSize() + this.getSegmentParallelOverscanSize();
    }

    public int getSegmentParallelActiveSize() {
        return this.parallelActiveSize;
    }

    public int getSegmentParallelOverscanSize() {
        return this.parallelOverscanSize;
    }

    public CCDGeometry getGeometry() {
        return this.ccdGeom;
    }
}

