/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import org.junit.Test;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsCheckSumTest;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;

public class FitsFileWriterTest
extends TestCase {
    private Random random = new Random(12345L);

    @Test
    public void testWrite() throws Exception {
        Date obs = new Date();
        Map<String, Map<String, Object>> metaDataSet = FitsFileWriterTest.generateMetaData(obs);
        Map<String, HeaderSpecification> config = FitsFileWriterTest.generateConfig();
        File tmp = File.createTempFile("img", "fits");
        tmp.deleteOnExit();
        int width = 256;
        int height = 256;
        DefaultImageSet imageSet = new DefaultImageSet();
        imageSet.addImage(width, height, metaDataSet);
        int i = 0;
        while (i < 1000) {
            Throwable throwable = null;
            Object var10_12 = null;
            try (FitsFileWriter writer = new FitsFileWriter(tmp, (ImageSet)imageSet, metaDataSet, config, FitsFileWriter.BitsPerPixel.BIT32);){
                writer.write(0, this.generateFakeImageData(width, height));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            FitsCheckSumTest.testCheckSum(tmp);
            throwable = null;
            var10_12 = null;
            try (Fits fits = new Fits(tmp);){
                fits.read();
                BasicHDU primary = fits.getHDU(0);
                FitsFileWriterTest.assertEquals((Object)obs, (Object)primary.getObservationDate());
                FitsFileWriterTest.assertEquals((Object)DateUtils.convertDateToMJD((Date)obs), (Object)primary.getHeader().findCard("MJD-OBS").getValue(Double.class, (Object)0.0));
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            ++i;
        }
    }

    public static Map<String, Map<String, Object>> generateMetaData(Date obs) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("Origin", "Galaxy9");
        metaData.put("SequenceNumber", 12);
        metaData.put("ExposureTime", 15);
        metaData.put("ObservationDate", obs);
        HashMap<String, Map<String, Object>> metaDataSet = new HashMap<String, Map<String, Object>>();
        metaDataSet.put("primary", metaData);
        return metaDataSet;
    }

    public static Map<String, HeaderSpecification> generateConfig() throws IOException {
        HashMap<String, HeaderSpecification> config = new HashMap<String, HeaderSpecification>();
        InputStream resourceAsStream = FitsFileWriterTest.class.getResourceAsStream("primary.spec");
        HeaderSpecification desc = new HeaderSpecification("primary", resourceAsStream);
        config.put("primary", desc);
        resourceAsStream = FitsFileWriterTest.class.getResourceAsStream("extended.spec");
        desc = new HeaderSpecification("extended", resourceAsStream);
        config.put("extended", desc);
        resourceAsStream = FitsFileWriterTest.class.getResourceAsStream("test_cond.spec");
        desc = new HeaderSpecification("test_cond", resourceAsStream);
        config.put("test_cond", desc);
        return config;
    }

    @Test
    public void testWriteNaN() throws ParseException, IOException, FitsException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.mm.dd hh:mm z");
        Date obs = sdf.parse("2015.09.15 14:11 UTC");
        Map<String, Map<String, Object>> metaDataSet = FitsFileWriterTest.generateMetaData(obs);
        metaDataSet.get("primary").put("ExposureTime", Float.valueOf(Float.NaN));
        Map<String, HeaderSpecification> config = FitsFileWriterTest.generateConfig();
        File tmp = File.createTempFile("img", "fits");
        tmp.deleteOnExit();
        int width = 256;
        int height = 256;
        DefaultImageSet imageSet = new DefaultImageSet();
        imageSet.addImage(width, height, metaDataSet);
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (FitsFileWriter writer = new FitsFileWriter(tmp, (ImageSet)imageSet, metaDataSet, config, FitsFileWriter.BitsPerPixel.BIT32);){
                writer.write(0, this.generateFakeImageData(width, height));
                FitsFileWriterTest.fail((String)"We should never get here");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private ByteBuffer generateFakeImageData(int imageWidth, int imageHeight) {
        int length = 4 * imageWidth * imageHeight;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer data = buffer.asIntBuffer();
        while (data.hasRemaining()) {
            data.put(this.random.nextInt(65536) - 32768);
        }
        return buffer;
    }
}

