/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rafts.demo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class RawImageConverter {
    private static final Logger logger = Logger.getLogger(RawImageConverter.class.getName());
    private final CCDGeometry geom;
    private final DefaultImageSet imageSet;
    private final BufferedImage rawImage;
    private static final int BUFFER_SIZE = 1000000;

    RawImageConverter(BufferedImage rawImage, CCDGeometry geom, int raftOffsetX, int raftOffsetY) {
        this.rawImage = rawImage;
        this.geom = geom;
        HashMap metaData = new HashMap();
        metaData.putAll(geom.getPrimaryHeaders());
        this.imageSet = new DefaultImageSet(metaData);
        long start = System.currentTimeMillis();
        for (CCDGeometry.CCDSegment segment : geom.getSegments()) {
            MetaDataSet metaDataSet = new MetaDataSet();
            Map imageMetaData = segment.getSegmentHeaders(false);
            metaDataSet.addMetaData("channel", imageMetaData);
            HashMap<String, Object> extra = new HashMap<String, Object>();
            extra.put("WCSNAMEr", "RAFT");
            extra.put("CTYPE1r", "RAFT_X");
            extra.put("CTYPE2r", "RAFT_Y");
            extra.put("CUNIT1r", "pixel");
            extra.put("CUNIT2r", "pixel");
            extra.put("CD1_1r", imageMetaData.get("CD1_1"));
            extra.put("CD1_2r", 0.0);
            extra.put("CD2_1r", 0.0);
            extra.put("CD2_2r", imageMetaData.get("CD2_2"));
            extra.put("CRPIX1r", ((Number)imageMetaData.get("CRPIX1")).intValue() + raftOffsetX);
            extra.put("CRPIX2r", ((Number)imageMetaData.get("CRPIX2")).intValue() + raftOffsetY);
            metaDataSet.addMetaData("raft-wcs", extra);
            this.imageSet.addImage(geom.getTotalSerialCount(), geom.getTotalParallelCount(), (Map)metaDataSet);
        }
        long stop = System.currentTimeMillis();
        logger.log(Level.FINE, "Analyzed image in {0}ms", stop - start);
    }

    ImageSet getImageSet() {
        return this.imageSet;
    }

    void pushDataToFile(FitsFileWriter writer) throws IOException {
        long start = System.currentTimeMillis();
        ByteBuffer dest = ByteBuffer.allocate(1000000);
        dest.order(ByteOrder.BIG_ENDIAN);
        for (CCDGeometry.CCDSegment segment : this.geom.getSegments()) {
            BufferedImage sImage = new BufferedImage(this.geom.getTotalParallelCount(), this.geom.getTotalSerialCount(), 11);
            Graphics2D g2 = sImage.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, sImage.getWidth(), sImage.getHeight());
            BufferedImage aImage = this.rawImage.getSubimage(segment.getColumn() * this.geom.getParallelActiveCount(), segment.getRow() * this.geom.getSerialActiveCount(), this.geom.getParallelActiveCount(), this.geom.getSerialActiveCount());
            int x = 0;
            int y = this.geom.getSerialPrescanCount();
            int w = this.geom.getParallelActiveCount();
            int h = this.geom.getSerialActiveCount();
            g2.translate(x, y);
            if (segment.getReadout().isRight()) {
                g2.translate(w, 0);
                g2.scale(-1.0, 1.0);
            }
            if (segment.getReadout().isDown()) {
                g2.translate(0, h);
                g2.scale(1.0, -1.0);
            }
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2.drawImage(aImage, 0, 0, w, h, null);
            g2.dispose();
            WritableRaster data = sImage.getRaster();
            int col = 0;
            while (col < this.geom.getTotalParallelCount()) {
                int row = 0;
                while (row < this.geom.getTotalSerialCount()) {
                    dest.putInt(data.getSample(col, row, 0));
                    if (!dest.hasRemaining()) {
                        dest.flip();
                        writer.write(segment.getChannel() - 1, dest);
                        dest.clear();
                    }
                    ++row;
                }
                ++col;
            }
            dest.flip();
            writer.write(segment.getChannel() - 1, dest);
            dest.clear();
        }
        long stop = System.currentTimeMillis();
        logger.log(Level.INFO, "Wrote image in {0}ms", stop - start);
    }
}

