/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rafts.demo;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import nom.tam.fits.FitsException;
import org.lsst.ccs.rafts.demo.RawImageConverter;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsFileWriterTest;
import org.lsst.ccs.utilities.image.HeaderSpecification;

public class RaftsDemo {
    public static void main(String[] args) throws InterruptedException, IOException, FitsException {
        CCDType type = CCDType.ITL;
        CCDGeometry geometry = type.getGeometry();
        int raftGapInPixels = 100;
        int totalHeight = 3 * geometry.getActiveSerialSize() + 2 * raftGapInPixels;
        int totalWidth = 3 * geometry.getActiveParallelSize() + 2 * raftGapInPixels;
        BufferedImage image = RaftsDemo.createRippledImage(totalWidth, totalHeight);
        Date obs = new Date();
        Map<String, Map<String, Object>> metaDataSet = FitsFileWriterTest.generateMetaData(obs);
        Map<String, HeaderSpecification> config = FitsFileWriterTest.generateConfig();
        int x = 0;
        while (x < 3) {
            int y = 0;
            while (y < 3) {
                String raftName = String.format("s99_r%d%d", x, y);
                File raftFile = new File("/tmp/" + raftName + ".fits");
                System.out.println(raftName);
                Map primaryHeaders = geometry.getPrimaryHeaders();
                primaryHeaders.put("Raft", primaryHeaders);
                int raftOffsetX = x * (raftGapInPixels + geometry.getParallelActiveCount());
                int raftOffsetY = y * (raftGapInPixels + geometry.getSerialActiveCount());
                BufferedImage ccdImage = image.getSubimage(raftOffsetX, raftOffsetY, geometry.getActiveParallelSize(), geometry.getActiveSerialSize());
                RawImageConverter ric = new RawImageConverter(ccdImage, geometry, raftOffsetX, raftOffsetY);
                Throwable throwable = null;
                Object var20_21 = null;
                try (FitsFileWriter ffw = new FitsFileWriter(raftFile, ric.getImageSet(), metaDataSet, config, FitsFileWriter.BitsPerPixel.BIT32);){
                    ric.pushDataToFile(ffw);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++y;
            }
            ++x;
        }
    }

    private static BufferedImage createRippledImage(int totalWidth, int totalHeight) {
        BufferedImage image = new BufferedImage(totalWidth, totalHeight, 11);
        WritableRaster raster = image.getRaster();
        int i = 0;
        while (i < totalWidth) {
            int j = 0;
            while (j < totalHeight) {
                double r = Math.sqrt(Math.pow(j - totalHeight / 2, 2.0) + Math.pow(i - totalWidth / 2, 2.0));
                raster.setSample(i, j, 0, (short)Math.round(1000.0 + 200.0 * Math.sin(r / 30.0)));
                ++j;
            }
            ++i;
        }
        return image;
    }
}

