/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCDGeometry;

public enum CCDType {
    E2V(10, 2002, 512, 22, 46, true),
    ITL(3, 2000, 509, 32, 48, false);

    private CCDGeometry ccdGeom;
    private static final int ROW_COUNT = 8;
    private static final int COLUMN_COUNT = 2;

    private CCDType(int prescan, int segmentWidth, int segmentHeight, int overscan, int parallelOverscan, boolean isE2V) {
        this.ccdGeom = new CCDGeometry(8, 2, segmentHeight, segmentWidth, prescan, overscan, parallelOverscan);
        int i = 0;
        while (i < 8) {
            this.ccdGeom.addSegment(i + 1, i, 1, CCDGeometry.ReadoutOrder.DownRight);
            ++i;
        }
        i = 8;
        while (i < 16) {
            this.ccdGeom.addSegment(i + 1, 15 - i, 0, isE2V ? CCDGeometry.ReadoutOrder.UpLeft : CCDGeometry.ReadoutOrder.DownLeft);
            ++i;
        }
    }

    public CCDGeometry getGeometry() {
        return this.ccdGeom;
    }
}

