/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.utilities.ccd.CCDTransform;

public class CCDGeometry {
    private final int segmentRowCount;
    private final int segmentColumnCount;
    private final int serialPrescan;
    private final int parallelActive;
    private final int serialActive;
    private final int serialOverscan;
    private final int parallelOverscan;
    private final List<CCDSegment> segments;
    private final CCDSegment[] channelMap;

    public CCDGeometry(int segmentRowCount, int segmentColumnCount, int serialActive, int parallelActive, int serialPrescan, int serialOverscan, int parallelOverscan) {
        this.segmentRowCount = segmentRowCount;
        this.segmentColumnCount = segmentColumnCount;
        this.serialPrescan = serialPrescan;
        this.parallelActive = parallelActive;
        this.serialActive = serialActive;
        this.serialOverscan = serialOverscan;
        this.parallelOverscan = parallelOverscan;
        this.segments = new ArrayList<CCDSegment>(segmentRowCount * segmentColumnCount);
        this.channelMap = new CCDSegment[segmentRowCount * segmentColumnCount];
    }

    public int getSerialPrescanCount() {
        return this.serialPrescan;
    }

    public int getParallelActiveCount() {
        return this.parallelActive;
    }

    public int getSerialActiveCount() {
        return this.serialActive;
    }

    public int getSerialOverscanCount() {
        return this.serialOverscan;
    }

    public int getParallelOverscanCount() {
        return this.parallelOverscan;
    }

    public int getSegmentRowCount() {
        return this.segmentRowCount;
    }

    public int getSegmentColumnCount() {
        return this.segmentColumnCount;
    }

    public int getTotalSerialCount() {
        return this.getSerialPrescanCount() + this.getSerialActiveCount() + this.getSerialOverscanCount();
    }

    public int getTotalParallelCount() {
        return this.getParallelActiveCount() + this.getParallelOverscanCount();
    }

    public int getTotalSerialSize() {
        return this.getTotalSerialCount() * this.getSegmentRowCount();
    }

    public int getActiveSerialSize() {
        return this.getSerialActiveCount() * this.getSegmentRowCount();
    }

    public int getTotalParallelSize() {
        return this.getTotalParallelCount() * this.getSegmentColumnCount();
    }

    public int getActiveParallelSize() {
        return this.getParallelActiveCount() * this.getSegmentColumnCount();
    }

    public CCDTransform getGlobalTransform() {
        return new GlobalTransform();
    }

    public CCDTransform getActiveTransform() {
        return new ActiveTransform();
    }

    public CCDSegment getSegment(int row, int column) {
        assert (row >= 0 && row < this.segmentRowCount);
        assert (column >= 0 && column < this.segmentColumnCount);
        return this.channelMap[column * this.segmentRowCount + row];
    }

    public List<CCDSegment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    private static String pair(String a, String b) {
        return "[" + a + "," + b + "]";
    }

    private static String range(int a, int b) {
        return String.valueOf(a) + ":" + b;
    }

    private static String range(int a, int b, boolean flip) {
        return flip ? CCDGeometry.range(b, a) : CCDGeometry.range(a, b);
    }

    void addSegment(int channel, int row, int column, ReadoutOrder readoutOrder) {
        CCDSegment segment = new CCDSegment(channel, row, column, readoutOrder);
        this.segments.add(segment);
        this.channelMap[column * this.segmentRowCount + row] = segment;
    }

    private String getBiasSec() {
        return CCDGeometry.pair(CCDGeometry.range(this.getSerialActiveCount() + this.getSerialPrescanCount() + 1, this.getSerialActiveCount() + this.getSerialPrescanCount() + this.getSerialOverscanCount()), CCDGeometry.range(1, this.getParallelActiveCount()));
    }

    private String getDataSec(boolean treatOverAndUnderscanAsActive) {
        if (treatOverAndUnderscanAsActive) {
            return CCDGeometry.pair(CCDGeometry.range(1, this.getTotalSerialCount()), CCDGeometry.range(1, this.getTotalParallelCount()));
        }
        return CCDGeometry.pair(CCDGeometry.range(this.getSerialPrescanCount() + 1, this.getSerialActiveCount() + this.getSerialPrescanCount()), CCDGeometry.range(1, this.getParallelActiveCount()));
    }

    private String getDetSize() {
        return CCDGeometry.pair(CCDGeometry.range(1, this.getActiveSerialSize()), CCDGeometry.range(1, this.getActiveParallelSize()));
    }

    public Map<String, Object> getPrimaryHeaders() {
        HashMap<String, Object> primaryMetaData = new HashMap<String, Object>();
        primaryMetaData.put("DETSIZE", this.getDetSize());
        return primaryMetaData;
    }

    private class ActiveTransform
    implements CCDTransform {
        private CCDSegment segment;
        private int serial;
        private int parallel;
        private int x;
        private int y;
        private int globalX;
        private int globalY;

        private ActiveTransform() {
        }

        @Override
        public void setXY(int x, int y) {
            assert (x >= 0 && x < CCDGeometry.this.getActiveParallelSize());
            assert (y >= 0 && y < CCDGeometry.this.getActiveSerialSize());
            this.x = x;
            this.y = y;
            int column = x / CCDGeometry.this.parallelActive;
            int row = y / CCDGeometry.this.serialActive;
            this.segment = CCDGeometry.this.getSegment(row, column);
            this.globalY = y + this.segment.row * (CCDGeometry.this.serialPrescan + CCDGeometry.this.serialOverscan) + (this.segment.getReadout().isDown() ? CCDGeometry.this.serialPrescan : CCDGeometry.this.serialOverscan);
            this.globalX = x + this.segment.column * CCDGeometry.this.parallelOverscan + (!this.segment.getReadout().isRight() ? 0 : CCDGeometry.this.parallelOverscan);
            this.serial = CCDGeometry.this.serialPrescan + (!this.segment.getReadout().isDown() ? y : CCDGeometry.this.serialActive - 1 - (y %= CCDGeometry.this.serialActive));
            this.parallel = !this.segment.getReadout().isRight() ? x : CCDGeometry.this.parallelActive - 1 - (x %= CCDGeometry.this.parallelActive);
        }

        @Override
        public CCDSegment getSegment() {
            return this.segment;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }

        @Override
        public int getParallel() {
            return this.parallel;
        }

        @Override
        public CCDTransform.PixelType getPixelType() {
            return CCDTransform.PixelType.ACTIVE;
        }

        @Override
        public int getGlobalX() {
            return this.globalX;
        }

        @Override
        public int getGlobalY() {
            return this.globalY;
        }

        public String toString() {
            return "ActiveTransform{segment=" + this.segment + ", serial=" + this.serial + ", parallel=" + this.parallel + ", x=" + this.x + ", y=" + this.y + '}';
        }

        @Override
        public void setSegmentSerialParallel(CCDSegment segment, int serial, int parallel) {
            assert (segment.getCCDGeometry() == CCDGeometry.this);
            assert (parallel >= 0 && parallel < CCDGeometry.this.parallelActive);
            assert (CCDGeometry.this.serialPrescan <= serial && serial < CCDGeometry.this.serialPrescan + CCDGeometry.this.serialActive);
            this.segment = segment;
            this.serial = serial;
            this.parallel = parallel;
            int yy = !segment.getReadout().isDown() ? serial : CCDGeometry.this.serialActive - 1 - (serial -= CCDGeometry.this.serialPrescan);
            int xx = !segment.getReadout().isRight() ? parallel : CCDGeometry.this.parallelActive - 1 - parallel;
            this.x = xx += segment.getColumn() * CCDGeometry.this.parallelActive;
            this.y = yy += segment.getRow() * CCDGeometry.this.serialActive;
            this.globalY = this.y + segment.row * (CCDGeometry.this.serialPrescan + CCDGeometry.this.serialOverscan) + (segment.getReadout().isDown() ? CCDGeometry.this.serialPrescan : CCDGeometry.this.serialOverscan);
            this.globalX = this.x + segment.column * CCDGeometry.this.parallelOverscan + (!segment.getReadout().isRight() ? 0 : CCDGeometry.this.parallelOverscan);
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }
    }

    public class CCDSegment {
        private ReadoutOrder readout;
        private int channel;
        private int row;
        private int column;

        private CCDSegment(int channel, int row, int column, ReadoutOrder readout) {
            this.readout = readout;
            this.channel = channel;
            this.row = row;
            this.column = column;
        }

        public Map<String, Object> getSegmentHeaders() {
            return this.getSegmentHeaders(false);
        }

        public Map<String, Object> getSegmentHeaders(boolean treatOverAndUnderscanAsActive) {
            HashMap<String, Object> imageMetaData = new HashMap<String, Object>();
            imageMetaData.put("EXTNAME", String.format("Segment%01d%01d", this.column, this.row));
            imageMetaData.put("CHANNEL", this.channel);
            imageMetaData.put("DATASEC", CCDGeometry.this.getDataSec(treatOverAndUnderscanAsActive));
            imageMetaData.put("DETSEC", this.getDetSec(treatOverAndUnderscanAsActive));
            if (!treatOverAndUnderscanAsActive) {
                imageMetaData.put("BIASSEC", CCDGeometry.this.getBiasSec());
            }
            imageMetaData.put("CCDSUM", "1 1");
            imageMetaData.put("LTV1", this.getLTV1());
            imageMetaData.put("LTV2", this.getLTV2());
            imageMetaData.put("LTM1_1", this.getLTM11());
            imageMetaData.put("LTM2_2", this.getLTM22());
            imageMetaData.put("WCSNAME", "PRIMARY");
            imageMetaData.put("CTYPE1", "CCD_X");
            imageMetaData.put("CTYPE2", "CCD_Y");
            imageMetaData.put("CUNIT1", "pixel");
            imageMetaData.put("CUNIT2", "pixel");
            imageMetaData.put("CD1_1", this.getCD11());
            imageMetaData.put("CD1_2", 0.0);
            imageMetaData.put("CD2_1", 0.0);
            imageMetaData.put("CD2_2", this.getCD22());
            imageMetaData.put("CRPIX1", this.getCRPIX1());
            imageMetaData.put("CRPIX2", this.getCRPIX2());
            return imageMetaData;
        }

        private String getDetSec(boolean treatOverAndUnderscanAsActive) {
            if (treatOverAndUnderscanAsActive) {
                return CCDGeometry.pair(CCDGeometry.range(CCDGeometry.this.getTotalSerialCount() * this.row + 1, CCDGeometry.this.getTotalSerialCount() * (this.row + 1), this.readout.isDown()), CCDGeometry.range(CCDGeometry.this.getTotalParallelCount() * this.column + 1, CCDGeometry.this.getTotalParallelCount() * (this.column + 1), this.readout.isRight()));
            }
            return CCDGeometry.pair(CCDGeometry.range(CCDGeometry.this.getSerialActiveCount() * this.row + 1, CCDGeometry.this.getSerialActiveCount() * (this.row + 1), this.readout.isDown()), CCDGeometry.range(CCDGeometry.this.getParallelActiveCount() * this.column + 1, CCDGeometry.this.getParallelActiveCount() * (this.column + 1), this.readout.isRight()));
        }

        private double getLTV1() {
            return this.readout.isDown() ? CCDGeometry.this.getSerialActiveCount() * (this.row + 1) : -(CCDGeometry.this.getSerialActiveCount() * this.row);
        }

        private double getLTV2() {
            return this.readout.isRight() ? CCDGeometry.this.getParallelActiveCount() * (this.column + 1) : CCDGeometry.this.getParallelActiveCount() * this.column;
        }

        private double getLTM11() {
            return this.readout.isDown() ? -1.0 : 1.0;
        }

        private double getLTM22() {
            return this.readout.isRight() ? -1.0 : 1.0;
        }

        private double getCD11() {
            return this.readout.isDown() ? -1.0 : 1.0;
        }

        private double getCD22() {
            return this.readout.isRight() ? -1.0 : 1.0;
        }

        private double getCRPIX1() {
            return this.readout.isDown() ? CCDGeometry.this.getTotalSerialCount() * (this.row + 1) + 1 : -(CCDGeometry.this.getTotalSerialCount() * this.row);
        }

        private double getCRPIX2() {
            return this.readout.isRight() ? CCDGeometry.this.getTotalParallelCount() * (this.column + 1) + 1 : CCDGeometry.this.getTotalParallelCount() * this.column;
        }

        public int getChannel() {
            return this.channel;
        }

        public ReadoutOrder getReadout() {
            return this.readout;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public CCDGeometry getCCDGeometry() {
            return CCDGeometry.this;
        }

        public String toString() {
            return "CCDSegment{readout=" + (Object)((Object)this.readout) + ", channel=" + this.channel + ", row=" + this.row + ", column=" + this.column + '}';
        }
    }

    private class GlobalTransform
    implements CCDTransform {
        private CCDSegment segment;
        private int serial;
        private int parallel;
        private CCDTransform.PixelType pixelType;
        private int x;
        private int y;

        private GlobalTransform() {
        }

        @Override
        public void setXY(int x, int y) {
            assert (x >= 0 && x < CCDGeometry.this.getTotalParallelSize());
            assert (y >= 0 && y < CCDGeometry.this.getTotalSerialSize());
            this.x = x;
            this.y = y;
            int column = x / CCDGeometry.this.getTotalParallelCount();
            int row = y / CCDGeometry.this.getTotalSerialCount();
            this.segment = CCDGeometry.this.getSegment(row, column);
            this.serial = !this.segment.getReadout().isDown() ? y : CCDGeometry.this.getTotalSerialCount() - 1 - (y %= CCDGeometry.this.getTotalSerialCount());
            int n = this.parallel = !this.segment.getReadout().isRight() ? x : CCDGeometry.this.getTotalParallelCount() - 1 - (x %= CCDGeometry.this.getTotalParallelCount());
            this.pixelType = this.parallel > CCDGeometry.this.parallelActive ? CCDTransform.PixelType.PARALLEL_OVERSCAN : (this.serial < CCDGeometry.this.serialPrescan ? CCDTransform.PixelType.SERIAL_PRESCAN : (this.serial > CCDGeometry.this.serialPrescan + CCDGeometry.this.serialActive ? CCDTransform.PixelType.SERIAL_OVERSCAN : CCDTransform.PixelType.ACTIVE));
        }

        @Override
        public void setSegmentSerialParallel(CCDSegment segment, int serial, int parallel) {
            assert (segment.getCCDGeometry() == CCDGeometry.this);
            assert (parallel >= 0 && parallel < CCDGeometry.this.getTotalParallelCount());
            assert (serial >= 0 && serial < CCDGeometry.this.getTotalSerialCount());
            this.segment = segment;
            this.serial = serial;
            this.parallel = parallel;
            this.pixelType = parallel > CCDGeometry.this.parallelActive ? CCDTransform.PixelType.PARALLEL_OVERSCAN : (serial < CCDGeometry.this.serialPrescan ? CCDTransform.PixelType.SERIAL_PRESCAN : (serial > CCDGeometry.this.serialPrescan + CCDGeometry.this.serialActive ? CCDTransform.PixelType.SERIAL_OVERSCAN : CCDTransform.PixelType.ACTIVE));
            int yy = !segment.getReadout().isDown() ? serial : CCDGeometry.this.getTotalSerialCount() - 1 - serial;
            int xx = !segment.getReadout().isRight() ? parallel : CCDGeometry.this.getTotalParallelCount() - 1 - parallel;
            this.x = xx += segment.getColumn() * CCDGeometry.this.getTotalParallelCount();
            this.y = yy += segment.getRow() * CCDGeometry.this.getTotalSerialCount();
        }

        @Override
        public CCDSegment getSegment() {
            return this.segment;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }

        @Override
        public int getParallel() {
            return this.parallel;
        }

        @Override
        public CCDTransform.PixelType getPixelType() {
            return this.pixelType;
        }

        public String toString() {
            return "GlobalTransform{segment=" + this.segment + ", serial=" + this.serial + ", parallel=" + this.parallel + ", pixelType=" + (Object)((Object)this.pixelType) + ", x=" + this.x + ", y=" + this.y + '}';
        }

        @Override
        public int getGlobalX() {
            return this.x;
        }

        @Override
        public int getGlobalY() {
            return this.y;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }
    }

    public static enum ReadoutOrder {
        DownRight(true, true),
        UpRight(false, true),
        DownLeft(true, false),
        UpLeft(false, false);

        private boolean down;
        private boolean right;

        private ReadoutOrder(boolean down, boolean right) {
            this.down = down;
            this.right = right;
        }

        public boolean isDown() {
            return this.down;
        }

        public boolean isRight() {
            return this.right;
        }
    }
}

