package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCDGeometry.ReadoutOrder;

/**
 * An enumeration of standard camera CCD types. Can be used to get the geometry of a CCD.
 * @author tonyj
 */
public enum CCDType {

    E2V(10, 2002, 512, 22, 46, true), ITL(3, 2000, 509, 32, 48, false);

    private CCDGeometry ccdGeom;
    private static final int ROW_COUNT = 8;
    private static final int COLUMN_COUNT = 2;

    private CCDType(int prescan, int segmentWidth, int segmentHeight,
            int overscan, int parallelOverscan, boolean isE2V) {

        ccdGeom = new CCDGeometry(ROW_COUNT, COLUMN_COUNT, segmentHeight, segmentWidth, prescan,
                overscan, parallelOverscan);
        
        for (int i = 0; i < 8; i++) {
            ccdGeom.addSegment(i + 1, i, 1, ReadoutOrder.DownRight);
        }
        for (int i = 8; i < 16; i++) {
            ccdGeom.addSegment(i + 1, 15-i, 0, isE2V ? ReadoutOrder.UpLeft : ReadoutOrder.DownLeft);
        }
    }
    /**
     * Get the geometry for this CCD.
     * @return The geometry corresponding to this CCD type.
     */
    public CCDGeometry getGeometry() {
        return ccdGeom;
    }

};
