package org.lsst.ccs.utilities.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsException;

/**
 * A default implementation of a metaDataSet.
 *
 * @author tonyj
 */
public class MetaDataSet extends HashMap<String, Map<String, Object>> {

    /**
     * Add a set of properties to a MetaDataSet. The properties will be
     * converted to the appropriate object type based on their value.
     *
     * @param name The name of the map to which the properties should be added
     * @param props The properties.
     */
    public void addProperties(String name, Properties props) {
        addMetaData(name, convertToMetaData(props));
    }

    /**
     * Add a set of meta-data to a named meta-data object. The named object will
     * be created if it does not already exist.
     *
     * @param name The name of the map to which the new meta-data should be
     * added
     * @param data The meta-data to add
     */
    public void addMetaData(String name, Map<String, Object> data) {
        Map<String, Object> meta = findOrCreateMetaData(name);
        meta.putAll(data);
    }

    public static Object getValue(Map<String, Map<String, Object>> metaDataSet, String name) {
        for (Map<String, Object> metaData : metaDataSet.values()) {
            Object result = metaData.get(name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public static Object getValue(Map<String, Map<String, Object>> metaDataSet, String map, String name) {
        if (map == null) {
            return getValue(metaDataSet, name);
        } else {
            Map<String, Object> metaData = metaDataSet.get(map);
            if (metaData == null) {
                return null;
            }
            return metaData.get(name);
        }
    }

    private Map<String, Object> findOrCreateMetaData(String name) {
        Map<String, Object> result = get(name);
        if (result == null) {
            result = new HashMap<>();
            put(name, result);
        }
        return result;
    }

    private Map<String, Object> convertToMetaData(Properties props) {
        Map<String, Object> result = new HashMap<>();
        // Note, this loops over all properties, including thos specified in the
        // default property list of the Properties object
        for (String name : props.stringPropertyNames()) {
            String value = props.getProperty(name);
            result.put(name, convertToMetaData(value));
        }
        return result;
    }

    private Object convertToMetaData(String value) {
        try {
            return Integer.decode(value);
        } catch (NumberFormatException x) {
            try {
                return Double.valueOf(value);
            } catch (NumberFormatException xx) {
                try {
                    return new FitsDate(value).toDate();
                } catch (FitsException xxx) {
                    if ("true".equalsIgnoreCase(value)) {
                        return Boolean.TRUE;
                    } else if ("false".equalsIgnoreCase(value)) {
                        return Boolean.FALSE;
                    } else {
                        return value;
                    }
                }
            }
        }
    }
}
