/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Random;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.util.BufferedFile;
import org.junit.Test;
import org.lsst.ccs.utilities.image.FitsCheckSum;

public class FitsCheckSumTest {
    @Test
    public void testCheckSumEncoding() {
        int cksum = 868229149;
        String checksumEnc = FitsCheckSum.checksumEnc((long)cksum, (boolean)true);
        TestCase.assertEquals((String)"hcHjjc9ghcEghc9g", (String)checksumEnc);
        long checksumDecode = FitsCheckSum.checksumDecode((String)checksumEnc);
        TestCase.assertEquals((long)cksum, (long)((checksumDecode ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL));
    }

    @Test
    public void testCheckSumEncoding2() {
        Pattern regex = Pattern.compile("[a-zA-Z0-9]{16}");
        Random r = new Random(12345L);
        int i = 0;
        while (i < 1000) {
            long cksum = r.nextLong() & 0xFFFFFFFFL;
            String checksumEnc = FitsCheckSum.checksumEnc((long)cksum, (boolean)false);
            TestCase.assertTrue((boolean)regex.matcher(checksumEnc).matches());
            long checksumDecode = FitsCheckSum.checksumDecode((String)checksumEnc);
            TestCase.assertEquals((long)cksum, (long)checksumDecode);
            ++i;
        }
    }

    @Test
    public void testCheckSum() {
        byte[] data = new byte[]{1, 1, 1, 1, -2, -2, -2, -2};
        long checksum = FitsCheckSum.computeChecksum((ByteBuffer)ByteBuffer.wrap(data));
        TestCase.assertEquals((long)0xFFFFFFFFL, (long)checksum);
    }

    @Test
    public void simpleCheckSumTest() throws FitsException, IOException {
        float[][] data = new float[10][10];
        Fits fits = new Fits();
        fits.addHDU(FitsFactory.HDUFactory((Object)data));
        FitsCheckSum.setChecksum((BasicHDU)fits.getHDU(0));
        File tmp = File.createTempFile("img", "fits");
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedFile bf = new BufferedFile(tmp, "rw");){
            fits.write((DataOutput)bf);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        FitsCheckSumTest.testCheckSum(tmp);
    }

    static void testCheckSum(File tmp) throws IOException {
        byte[] bytes = Files.readAllBytes(tmp.toPath());
        long checksum = FitsCheckSum.checksum((byte[])bytes);
        TestCase.assertEquals((long)0xFFFFFFFFL, (long)checksum);
    }
}

