/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;

public class FitsFileWriter
implements Closeable {
    private final BufferedFile bf;
    private final long[] position0;
    private final long[] position;
    private BasicHDU[] image_hdu = new BasicHDU[16];

    public FitsFileWriter() {
        this.bf = null;
        this.position0 = null;
        this.position = null;
    }

    public FitsFileWriter(File file, ImageSet images, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config, BitsPerPixel bits) throws IOException, FitsException {
        Header header;
        this.position0 = new long[images.getImages().size() + 1];
        this.position = new long[images.getImages().size()];
        int[][] intDummyData = new int[1][1];
        short[][] shortDummyData = new short[1][1];
        Object[] tableDummyData = new Object[]{};
        Object dummyData = bits == BitsPerPixel.BIT16 ? shortDummyData : (Object)intDummyData;
        this.bf = new BufferedFile(file, "rw");
        FitsFactory.setUseHierarch((boolean)true);
        BasicHDU primary = BasicHDU.getDummyHDU();
        this.addMetaDataToHeader(primary, "primary", metaData, config);
        primary.getHeader().write((ArrayDataOutput)this.bf);
        int i = 0;
        for (ImageSet.Image image : images.getImages()) {
            BasicHDU hdu;
            this.image_hdu[i] = hdu = FitsFactory.HDUFactory((Object)dummyData);
            this.addMetaDataToHeader(hdu, "extended", image.getMetaData(), config);
            if (bits == BitsPerPixel.BIT16) {
                hdu.addValue("BSCALE", 1.0, "Unsigned 16 bit data");
                hdu.addValue("BZERO", 32768, "Unsigned 16 bit data");
            }
            header = hdu.getHeader();
            header.setXtension("IMAGE");
            header.setNaxis(1, image.getWidth());
            header.setNaxis(2, image.getHeight());
            this.position0[i] = this.bf.getFilePointer();
            header.write((ArrayDataOutput)this.bf);
            this.position[i] = this.bf.getFilePointer();
            long imageSize = (bits == BitsPerPixel.BIT16 ? 2L : 4L) * (long)image.getWidth() * (long)image.getHeight();
            this.bf.seek(this.bf.getFilePointer() + imageSize);
            FitsUtil.pad((ArrayDataOutput)this.bf, (long)imageSize);
            ++i;
        }
        this.position0[i] = this.bf.getFilePointer();
        FitsFactory.setUseAsciiTables((boolean)false);
        for (String key : config.keySet()) {
            if ("primary".equals(key) || "extended".equals(key)) continue;
            BasicHDU binary = FitsFactory.HDUFactory((Object)tableDummyData);
            this.addMetaDataToHeader(binary, key, metaData, config);
            header = binary.getHeader();
            header.setXtension("BINTABLE");
            header.write((ArrayDataOutput)this.bf);
        }
    }

    public BasicHDU[] getImage_hdu() {
        return this.image_hdu;
    }

    /*
     * Unable to fully structure code
     */
    public void write(int imageIndex, ByteBuffer src) throws IOException {
        block2: {
            length = src.remaining();
            if ((long)length + this.position[imageIndex] > this.position0[imageIndex + 1]) {
                throw new IOException("Too much data written for image: " + imageIndex);
            }
            this.bf.seek(this.position[imageIndex]);
            if (!src.hasArray()) ** GOTO lbl11
            this.bf.write(src.array(), src.arrayOffset() + src.position(), src.remaining());
            src.position(src.limit());
            break block2;
lbl-1000:
            // 1 sources

            {
                this.bf.write((int)src.get());
lbl11:
                // 2 sources

                ** while (src.remaining() > 0)
            }
        }
        v0 = imageIndex;
        this.position[v0] = this.position[v0] + (long)length;
    }

    @Override
    public void close() throws IOException {
        this.bf.close();
    }

    public void addMetaDataToHeader(int image_index, String specName, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config) throws HeaderCardException, IOException, FitsException {
        this.bf.seek(this.position0[image_index]);
        this.addMetaDataToHeader(this.getImage_hdu()[image_index], specName, metaData, config);
        this.getImage_hdu()[image_index].write((ArrayDataOutput)this.bf);
    }

    private void addMetaDataToHeader(BasicHDU hdu, String specName, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config) throws HeaderCardException, IOException {
        HeaderSpecification spec = config.get(specName);
        if (spec == null) {
            throw new IOException("Missing specification for header: " + specName);
        }
        for (HeaderSpecification.HeaderLine header : spec.getHeaders()) {
            Object value = header.getValue(metaData);
            try {
                if (value == null) continue;
                switch (header.getDataType()) {
                    case Integer: {
                        hdu.addValue(header.getKeyword(), ((Number)value).intValue(), header.getComment());
                        break;
                    }
                    case Float: {
                        hdu.addValue(header.getKeyword(), ((Number)value).doubleValue(), header.getComment());
                        break;
                    }
                    case Boolean: {
                        hdu.addValue(header.getKeyword(), ((Boolean)value).booleanValue(), header.getComment());
                        break;
                    }
                    default: {
                        hdu.addValue(header.getKeyword(), String.valueOf(value), header.getComment());
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new IOException(String.format("Meta-data header %s with value %s(%s) cannot be converted to type %s", new Object[]{header.getKeyword(), value, value.getClass(), header.getDataType()}));
            }
        }
    }

    public void addBinaryTable(String pddatfile, String fitsfile, String extnam, String c1name, String c2name, Double tstart) {
        FileReader fstream = null;
        File pdFl = new File(pddatfile);
        double pdavg_all = 0.0;
        double pdavg_expo = 0.0;
        try {
            if (!pdFl.exists()) {
                System.out.println("Cannot find the input file of PD values");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to verify existence of file" + e);
        }
        try {
            fstream = new FileReader(pdFl);
        }
        catch (FileNotFoundException e) {
            System.out.println("Failed to open reader stream for file (" + pddatfile + ") for reason " + e);
        }
        ArrayList<Double> pddata = new ArrayList<Double>();
        ArrayList<Double> tmdata = new ArrayList<Double>();
        try {
            if (fstream != null) {
                double pdsum = 0.0;
                System.out.println("reading file of buffered values from either Bias or PhotoDiode device");
                BufferedReader in = new BufferedReader(fstream);
                while (in.ready()) {
                    String line = in.readLine();
                    double pdtime = Double.valueOf(line.split(" ")[0]);
                    double pdval = Double.valueOf(line.split(" ")[1]);
                    tmdata.add(pdtime);
                    pddata.add(pdval);
                    pdsum += pdval;
                }
                in.close();
                if (pddata.size() > 0) {
                    pdavg_all = pdsum / (double)pddata.size();
                }
                System.out.println("Average of all PD values is " + pdavg_all);
                pdsum = 0.0;
                int nelem = 0;
                Iterator it = pddata.iterator();
                while (it.hasNext()) {
                    double pdval = (Double)it.next();
                    if (!(Math.abs(pdval) > Math.abs(pdavg_all))) continue;
                    pdsum += pdval;
                    ++nelem;
                }
                if (nelem > 0) {
                    pdavg_expo = pdsum / (double)nelem;
                }
                System.out.println("Number elements in luminous curve region = " + nelem);
                System.out.println("Sum of PD values in luminous region = " + pdsum);
                System.out.println("PD average value during exposure = " + pdavg_expo);
            }
        }
        catch (IOException ee) {
            System.out.println("Failed to read input PD data" + ee);
        }
        BinaryTableHDU bhdu = null;
        System.out.println("Trying to open FITS file " + fitsfile);
        Fits f = null;
        Fits f1 = null;
        try {
            f = new Fits(fitsfile);
            f1 = new Fits();
        }
        catch (FitsException ex) {
            Logger.getLogger(FitsFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            f.read();
            System.out.println("Number of HDUs = " + f.getNumberOfHDUs());
            int bhduidx = 0;
            f1.addHDU(f.getHDU(0));
            System.out.println("Setting MONDIODE value in primary header to " + (pdavg_expo /= 1.0E-9));
            if (f1.getHDU(0).getHeader().containsKey("MONDIODE")) {
                f1.getHDU(0).getHeader().deleteKey("MONDIODE");
            }
            f1.getHDU(0).getHeader().addValue("MONDIODE", pdavg_expo, "avg PD value (nA) during expo");
            System.out.println("Setting HIERARCH.AMP2-CURRENT value in primary header to " + pdavg_expo);
            if (f1.getHDU(0).getHeader().containsKey("HIERARCH.AMP2-CURRENT")) {
                f1.getHDU(0).getHeader().deleteKey("HIERARCH.AMP2-CURRENT");
            }
            f1.getHDU(0).getHeader().addValue("HIERARCH.AMP2-CURRENT", pdavg_expo * 1000.0, "avg PD value (nA) during expo");
            int ihdu = 1;
            while (ihdu < f.getNumberOfHDUs()) {
                String extn = f.getHDU(ihdu).getHeader().getStringValue("EXTNAME");
                System.out.println("iHDU = " + ihdu + " EXTNAME = " + extn + " searching for " + extnam);
                if (extn.contains(extnam)) {
                    bhdu = (BinaryTableHDU)f.getHDU(ihdu);
                    bhduidx = ihdu;
                    System.out.println("Found the extension to be modified.");
                    break;
                }
                f1.addHDU(f.getHDU(ihdu));
                ++ihdu;
            }
            if (bhduidx == 0) {
                throw new Exception("Failed to find the requested extension " + extnam);
            }
            double[] tmdbl = new double[tmdata.size()];
            int i = 0;
            for (Double tmd : tmdata) {
                tmdbl[i++] = tmd;
            }
            double[] pddbl = new double[pddata.size()];
            i = 0;
            for (Double pdd : pddata) {
                pddbl[i++] = pdd;
            }
            bhdu.addColumn((Object)tmdbl);
            bhdu.addColumn((Object)pddbl);
            bhdu.getHeader().setNaxis(1, 16);
            bhdu.getHeader().setNaxis(2, pddata.size());
            bhdu.getHeader().addValue("TFIELDS", 2L, " ");
            bhdu.setColumnName(0, c1name, "time");
            bhdu.setColumnName(1, c2name, "values");
            System.out.println("Number of columns = " + bhdu.getNCols());
            System.out.println("Number of rows = " + bhdu.getNRows());
            bhdu.info();
            bhdu.getHeader().addValue("TSTART", tstart.doubleValue(), "Time of Start of Readings");
            BufferedFile bfnew = new BufferedFile(String.valueOf(fitsfile) + "-new", "rw");
            f1.addHDU((BasicHDU)bhdu);
            ihdu = bhduidx + 1;
            while (ihdu < f.getNumberOfHDUs()) {
                f1.addHDU(f.getHDU(ihdu));
                ++ihdu;
            }
            f1.write((DataOutput)bfnew);
            bfnew.flush();
            bfnew.close();
            Runtime r = Runtime.getRuntime();
            r.exec("mv " + fitsfile + "-new " + fitsfile);
        }
        catch (FitsException ex) {
            Logger.getLogger(FitsFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FitsFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(FitsFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public double getFluxStats(String fitsfile) {
        Double minflux = Double.MAX_VALUE;
        Double fluxsum = 0.0;
        Double fluxentries = 0.0;
        System.out.println("Trying to open FITS file " + fitsfile);
        Fits f = null;
        try {
            f = new Fits(fitsfile);
        }
        catch (FitsException ex) {
            Logger.getLogger(FitsFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            f.read();
            System.out.println("Number of HDUs = " + f.getNumberOfHDUs());
            double gain = f.getHDU(0).getHeader().getDoubleValue("CCDGAIN");
            double exptime = f.getHDU(0).getHeader().getDoubleValue("EXPTIME");
            int ihdu = 1;
            while (ihdu < f.getNumberOfHDUs()) {
                String extn = f.getHDU(ihdu).getHeader().getStringValue("EXTNAME");
                System.out.println("iHDU = " + ihdu + " EXTNAME = " + extn + " searching for Segment");
                if (extn.contains("Segment")) {
                    double avg = f.getHDU(ihdu).getHeader().getDoubleValue("AVWOBIAS");
                    double bias = f.getHDU(ihdu).getHeader().getDoubleValue("AVGBIAS");
                    double signal = (avg - bias) * gain;
                    double flux = Math.max(signal / exptime, 1.0);
                    minflux = Math.min(minflux, flux);
                    fluxsum = fluxsum + flux;
                    fluxentries = fluxentries + 1.0;
                    System.out.println(String.valueOf(extn) + " signal = " + signal + " exptime = " + exptime + " flux = " + flux + " minflux for CCD = " + minflux);
                }
                ++ihdu;
            }
        }
        catch (FitsException ex) {
            Logger.getLogger(FitsFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FitsFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(FitsFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return fluxsum / fluxentries;
    }

    public static enum BitsPerPixel {
        BIT16,
        BIT32;

    }
}

