/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Random;
import junit.framework.TestCase;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;

public class FitsFileWriterTest
extends TestCase {
    public void testWrite() throws Exception {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("Origin", "Galaxy9");
        metaData.put("SequenceNumber", 12);
        metaData.put("ExposureTime", 15);
        HashMap<String, HashMap<String, Object>> metaDataSet = new HashMap<String, HashMap<String, Object>>();
        metaDataSet.put("primary", metaData);
        HashMap<String, HeaderSpecification> config = new HashMap<String, HeaderSpecification>();
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("primary.spec");
        HeaderSpecification desc = new HeaderSpecification("primary", resourceAsStream);
        config.put("primary", desc);
        resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("extended.spec");
        desc = new HeaderSpecification("extended", resourceAsStream);
        config.put("extended", desc);
        resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("test_cond.spec");
        desc = new HeaderSpecification("test_cond", resourceAsStream);
        config.put("test_cond", desc);
        File tmp = File.createTempFile("img", "fits");
        tmp.deleteOnExit();
        int width = 256;
        int height = 256;
        DefaultImageSet imageSet = new DefaultImageSet();
        imageSet.addImage(width, height, metaDataSet);
        Throwable throwable = null;
        Object var11_12 = null;
        try (FitsFileWriter writer = new FitsFileWriter(tmp, (ImageSet)imageSet, metaDataSet, config, FitsFileWriter.BitsPerPixel.BIT32);){
            writer.write(0, this.generateFakeImageData(width, height));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ByteBuffer generateFakeImageData(int imageWidth, int imageHeight) {
        int length = 4 * imageWidth * imageHeight;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer data = buffer.asIntBuffer();
        Random random = new Random();
        while (data.hasRemaining()) {
            data.put(random.nextInt(65536) - 32768);
        }
        return buffer;
    }
}

