/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;

public class FitsFileWriter
implements Closeable {
    private final BufferedFile bf;
    private final long[] position0;
    private final long[] position;

    public FitsFileWriter(File file, ImageSet images, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config, BitsPerPixel bits) throws IOException, FitsException {
        Header header;
        this.position0 = new long[images.getImages().size() + 1];
        this.position = new long[images.getImages().size()];
        int[][] intDummyData = new int[1][1];
        short[][] shortDummyData = new short[1][1];
        Object[] tableDummyData = new Object[]{};
        Object dummyData = bits == BitsPerPixel.BIT16 ? shortDummyData : (Object)intDummyData;
        this.bf = new BufferedFile(file, "rw");
        BasicHDU primary = BasicHDU.getDummyHDU();
        this.addMetaDataToHeader(primary, "primary", metaData, config);
        primary.getHeader().write((ArrayDataOutput)this.bf);
        int i = 0;
        for (ImageSet.Image image : images.getImages()) {
            BasicHDU hdu = FitsFactory.HDUFactory((Object)dummyData);
            this.addMetaDataToHeader(hdu, "extended", image.getMetaData(), config);
            if (bits == BitsPerPixel.BIT16) {
                hdu.addValue("BSCALE", 1.0, "Unsigned 16 bit data");
                hdu.addValue("BZERO", 0, "Unsigned 16 bit data");
            }
            header = hdu.getHeader();
            header.setXtension("IMAGE");
            header.setNaxis(1, image.getWidth());
            header.setNaxis(2, image.getHeight());
            this.position0[i] = this.bf.getFilePointer();
            header.write((ArrayDataOutput)this.bf);
            this.position[i] = this.bf.getFilePointer();
            long imageSize = (bits == BitsPerPixel.BIT16 ? 2L : 4L) * (long)image.getWidth() * (long)image.getHeight();
            this.bf.seek(this.bf.getFilePointer() + imageSize);
            FitsUtil.pad((ArrayDataOutput)this.bf, (long)imageSize);
            ++i;
        }
        this.position0[i] = this.bf.getFilePointer();
        FitsFactory.setUseAsciiTables((boolean)false);
        for (String key : config.keySet()) {
            if ("primary".equals(key) || "extended".equals(key)) continue;
            BasicHDU binary = FitsFactory.HDUFactory((Object)tableDummyData);
            this.addMetaDataToHeader(binary, key, metaData, config);
            header = binary.getHeader();
            header.setXtension("BINTABLE");
            header.write((ArrayDataOutput)this.bf);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void write(int imageIndex, ByteBuffer src) throws IOException {
        block2: {
            length = src.remaining();
            if ((long)length + this.position[imageIndex] > this.position0[imageIndex + 1]) {
                throw new IOException("Too much data written for image: " + imageIndex);
            }
            this.bf.seek(this.position[imageIndex]);
            if (!src.hasArray()) ** GOTO lbl11
            this.bf.write(src.array(), src.arrayOffset() + src.position(), src.remaining());
            src.position(src.limit());
            break block2;
lbl-1000:
            // 1 sources

            {
                this.bf.write((int)src.get());
lbl11:
                // 2 sources

                ** while (src.remaining() > 0)
            }
        }
        v0 = imageIndex;
        this.position[v0] = this.position[v0] + (long)length;
    }

    @Override
    public void close() throws IOException {
        this.bf.close();
    }

    private void addMetaDataToHeader(BasicHDU hdu, String specName, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config) throws HeaderCardException, IOException {
        HeaderSpecification spec = config.get(specName);
        if (spec == null) {
            throw new IOException("Missing specification for header: " + specName);
        }
        for (HeaderSpecification.HeaderLine header : spec.getHeaders()) {
            Object value = header.getValue(metaData);
            try {
                if (value == null) continue;
                switch (header.getDataType()) {
                    case Integer: {
                        hdu.addValue(header.getKeyword(), ((Number)value).intValue(), header.getComment());
                        break;
                    }
                    case Float: {
                        hdu.addValue(header.getKeyword(), ((Number)value).doubleValue(), header.getComment());
                        break;
                    }
                    case Boolean: {
                        hdu.addValue(header.getKeyword(), ((Boolean)value).booleanValue(), header.getComment());
                        break;
                    }
                    default: {
                        hdu.addValue(header.getKeyword(), String.valueOf(value), header.getComment());
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new IOException(String.format("Meta-data header %s with value %s(%s) cannot be converted to type %s", new Object[]{header.getKeyword(), value, value.getClass(), header.getDataType()}));
            }
        }
    }

    public static enum BitsPerPixel {
        BIT16,
        BIT32;

    }
}

