package org.lsst.ccs.utilities.image;

import java.util.List;
import java.util.Map;

/**
 * Represents a set of images read from the DAQ. Each image typically contains
 * the data from a single amplifier, and is written to its own extended HDU in 
 * a fits file.
 * @author tonyj
 */
public interface ImageSet {
    /** The list of images, each of which will be written as a separate extended
     * HDU to the fits file.
     * @return The list of images
     */  
    List<Image> getImages();
    /**
     * Get any meta-data associated with the image set itself
     * @return The meta-data map or <code>null</code> if no meta-data is available
     */
    Map<String, Object> getMetaData();

    public interface Image {
        /**
         * Get any meta-data associated with the individual image
         * @return The meta-data map or <code>null</code> if no meta-data is available
         */
        public Map<String, Map<String, Object>> getMetaData();
        /* 
         * Get width in pixels (including overscan?)
         * @return 
         */
        public int getWidth();
        /**
         * Get height of image in pixels (including overscan?)
         * @return 
         */
        public int getHeight();
    }
}
