/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.imagenaming.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.imagenaming.rest.TestServer;

public class FileServerTest {
    private static TestServer testServer;

    @BeforeAll
    public static void setUpClass() throws URISyntaxException, IOException {
        testServer = new TestServer();
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        testServer.shutdown();
    }

    @BeforeEach
    public void setUp() throws URISyntaxException {
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testGenericCamera() throws URISyntaxException, InterruptedException, ProtocolException, MalformedURLException, IOException {
        Client client = ClientBuilder.newClient();
        URI infoURI = testServer.getServerURI().resolve("rest/imageNameService?sourceIndex=100&n=15");
        Response response = client.target(infoURI).request(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        List images = (List)response.readEntity(List.class);
        Assertions.assertEquals((int)15, (int)images.size());
        Assert.assertTrue((boolean)Pattern.compile("GC100_O_\\d+_000001").matcher((CharSequence)images.get(0)).matches());
    }

    @Test
    public void testElectrometer() throws URISyntaxException, InterruptedException, ProtocolException, MalformedURLException, IOException {
        Client client = ClientBuilder.newClient();
        URI infoURI = testServer.getServerURI().resolve("rest/imageNameService?sourceIndex=1&n=15&source=Electrometer");
        Response response = client.target(infoURI).request(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        List images = (List)response.readEntity(List.class);
        Assertions.assertEquals((int)15, (int)images.size());
        Assert.assertTrue((boolean)Pattern.compile("EM1_O_\\d+_000001").matcher((CharSequence)images.get(0)).matches());
    }

    @Test
    public void testFiberSpectrograph() throws URISyntaxException, InterruptedException, ProtocolException, MalformedURLException, IOException {
        Client client = ClientBuilder.newClient();
        URI infoURI = testServer.getServerURI().resolve("rest/imageNameService?sourceIndex=1&n=15&source=FiberSpectrograph");
        Response response = client.target(infoURI).request(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        List images = (List)response.readEntity(List.class);
        Assertions.assertEquals((int)15, (int)images.size());
        Assert.assertTrue((boolean)Pattern.compile("FS1_O_\\d+_000001").matcher((CharSequence)images.get(0)).matches());
    }

    @Test
    public void testAuxTel() throws URISyntaxException, InterruptedException, ProtocolException, MalformedURLException, IOException {
        Client client = ClientBuilder.newClient();
        URI infoURI = testServer.getServerURI().resolve("rest/imageNameService?sourceIndex=1&n=15&source=AuxTel");
        Response response = client.target(infoURI).request(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)500, (int)response.getStatus());
        infoURI = testServer.getServerURI().resolve("rest/imageNameService?n=15&source=AuxTel");
        response = client.target(infoURI).request(new String[]{"application/json"}).get();
        List images = (List)response.readEntity(List.class);
        Assertions.assertEquals((int)15, (int)images.size());
        Assert.assertTrue((boolean)Pattern.compile("AT_O_\\d+_000001").matcher((CharSequence)images.get(0)).matches());
    }
}

