/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.imagenaming.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.ImageNameAssigner;
import org.lsst.ccs.imagenaming.Source;

@Path(value="/")
@Produces(value={"application/json"})
public class DataSource {
    private ImageNameAssigner imageNameAssigner;
    private static final Logger LOG = Logger.getLogger(DataSource.class.getName());

    @Context
    public void setServletContext(ServletContext context) throws IOException {
        String url;
        String dbURL = "jdbc:h2:mem:test;MODE=MYSQL";
        if (context != null && (url = context.getInitParameter("org.lsst.ccs.imagenaming.rest.dbURL")) != null) {
            dbURL = url;
        }
        LOG.log(Level.INFO, "Using dbURL: {0}", dbURL);
        this.imageNameAssigner = new ImageNameAssigner(dbURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="imageNameService")
    public List<String> imageNameService(@QueryParam(value="n") int n, @QueryParam(value="source") Source source, @QueryParam(value="sourceIndex") int sourceIndex) throws SQLException {
        if (n == 0) {
            n = 1;
        }
        if (source == null) {
            source = Source.GenericCamera;
        }
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        try {
            List<String> list = this.imageNameAssigner.assignImageNames(source, sourceIndex, Controller.OCS, timeZone, Duration.ofHours(12L), n, null).stream().map(ImageName::toString).collect(Collectors.toList());
            return list;
        }
        finally {
            this.imageNameAssigner.close();
            LOG.log(Level.INFO, "Using dbURL closed");
        }
    }
}

